/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.json;

import com.cntaiping.ec.cloud.common.exception.TPSCBPError;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;

public class JsonUtils {
    private static ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public void setObjectMapper(ObjectMapper objectMapper) {
        OBJECT_MAPPER = objectMapper;
    }

    public static <T> T readValue(JsonParser p, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(p, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(p, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static final <T> T readValue(JsonParser p, ResolvedType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(p, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(JsonParser p, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(p, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T extends TreeNode> T readTree(JsonParser p) {
        try {
            return (T)OBJECT_MAPPER.readTree(p);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> MappingIterator<T> readValues(JsonParser p, ResolvedType valueType) {
        return JsonUtils.readValues(p, (JavaType)valueType);
    }

    public static <T> MappingIterator<T> readValues(JsonParser p, JavaType valueType) {
        try {
            return OBJECT_MAPPER.readValues(p, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> MappingIterator<T> readValues(JsonParser p, Class<T> valueType) {
        try {
            return OBJECT_MAPPER.readValues(p, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> MappingIterator<T> readValues(JsonParser p, TypeReference<T> valueTypeRef) {
        try {
            return OBJECT_MAPPER.readValues(p, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(InputStream in) {
        try {
            return OBJECT_MAPPER.readTree(in);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(Reader r) {
        try {
            return OBJECT_MAPPER.readTree(r);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(String content) {
        try {
            return OBJECT_MAPPER.readTree(content);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(byte[] content) {
        try {
            return OBJECT_MAPPER.readTree(content);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(byte[] content, int offset, int len) {
        try {
            return OBJECT_MAPPER.readTree(content, offset, len);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(File file) {
        try {
            return OBJECT_MAPPER.readTree(file);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode readTree(URL source) {
        try {
            return OBJECT_MAPPER.readTree(source);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeValue(JsonGenerator g, Object value) {
        try {
            OBJECT_MAPPER.writeValue(g, value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeTree(JsonGenerator g, TreeNode rootNode) {
        try {
            OBJECT_MAPPER.writeTree(g, rootNode);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeTree(JsonGenerator g, JsonNode rootNode) {
        try {
            OBJECT_MAPPER.writeTree(g, rootNode);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static ObjectNode createObjectNode() {
        try {
            return OBJECT_MAPPER.createObjectNode();
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static ArrayNode createArrayNode() {
        try {
            return OBJECT_MAPPER.createArrayNode();
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode missingNode() {
        try {
            return OBJECT_MAPPER.missingNode();
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonNode nullNode() {
        try {
            return OBJECT_MAPPER.nullNode();
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static JsonParser treeAsTokens(TreeNode n) {
        try {
            return OBJECT_MAPPER.treeAsTokens(n);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T treeToValue(TreeNode n, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.treeToValue(n, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T extends JsonNode> T valueToTree(Object fromValue) {
        try {
            return (T)OBJECT_MAPPER.valueToTree(fromValue);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static boolean canSerialize(Class<?> type) {
        try {
            return OBJECT_MAPPER.canSerialize(type);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static boolean canSerialize(Class<?> type, AtomicReference<Throwable> cause) {
        try {
            return OBJECT_MAPPER.canSerialize(type, cause);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static boolean canDeserialize(JavaType type) {
        try {
            return OBJECT_MAPPER.canDeserialize(type);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static boolean canDeserialize(JavaType type, AtomicReference<Throwable> cause) {
        try {
            return OBJECT_MAPPER.canDeserialize(type, cause);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(File src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(File src, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(File src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(URL src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(URL src, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(URL src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(String content, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(String content, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(String content, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(content, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(Reader src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(Reader src, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(Reader src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(InputStream src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(InputStream src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, int offset, int len, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, offset, len, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, int offset, int len, TypeReference<T> valueTypeRef) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, offset, len, valueTypeRef);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(byte[] src, int offset, int len, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, offset, len, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(DataInput src, Class<T> valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static <T> T readValue(DataInput src, JavaType valueType) {
        try {
            return (T)OBJECT_MAPPER.readValue(src, valueType);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeValue(File resultFile, Object value) {
        try {
            OBJECT_MAPPER.writeValue(resultFile, value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeValue(OutputStream out, Object value) {
        try {
            OBJECT_MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeValue(DataOutput out, Object value) {
        try {
            OBJECT_MAPPER.writeValue(out, value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static void writeValue(Writer w, Object value) {
        try {
            OBJECT_MAPPER.writeValue(w, value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static String writeValueAsString(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    public static byte[] writeValueAsBytes(Object value) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw TPSCBPError.JSON_ERROR.getInfo().initialize(e);
        }
    }

    static {
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
    }
}

