/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.log;

import com.cntaiping.ec.cloud.common.utils.json.JsonUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.springframework.ui.Model;
import org.springframework.web.servlet.ModelAndView;

public class TrackUtils {
    private TrackUtils() {
    }

    public static void track(Logger logger, JoinPoint joinPoint, Object result) {
        try {
            if (logger == null || joinPoint == null || result == null) {
                return;
            }
            String threadName = Thread.currentThread().getName();
            String className = joinPoint.getSignature().getDeclaringTypeName();
            String methodName = joinPoint.getSignature().getName();
            if (logger.isDebugEnabled()) {
                logger.debug("### TRACK==>::THREAD:[{}], METHOD:[{}#{}]", new Object[]{threadName, className, methodName});
            }
            String[] parameterNames = ((MethodSignature)joinPoint.getSignature()).getParameterNames();
            Object[] args = joinPoint.getArgs();
            for (int i = 0; i < args.length; ++i) {
                String parameterName = parameterNames[i];
                Object parameterValue = args[i];
                if (!logger.isDebugEnabled()) continue;
                logger.debug("### TRACK==>::METHOD:[{}], IN:[{}]==>[{}]", new Object[]{methodName, parameterName, TrackUtils.toString(parameterValue)});
            }
            if (logger.isDebugEnabled()) {
                logger.debug("### TRACK==>::METHOD:[{}], OUT:[{}]", (Object)methodName, TrackUtils.toString(result));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Object toString(Object value) {
        try {
            return TrackUtils.isUnwrapped(value) ? value : JsonUtils.writeValueAsString(value);
        }
        catch (Exception e) {
            return value;
        }
    }

    private static boolean isUnwrapped(Object value) {
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        return clazz.isPrimitive() || clazz.isAnnotation() || clazz.isEnum() || value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Boolean || value instanceof Integer || value instanceof Long || value instanceof Float || value instanceof Double || value instanceof String || value instanceof Date || value instanceof LocalDate || value instanceof LocalTime || value instanceof LocalDateTime || value instanceof BigDecimal || value instanceof ServletRequest || value instanceof ServletResponse || value instanceof Model || value instanceof ModelAndView;
    }
}

