/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.ec.cloud.common.utils.trace;

import com.cntaiping.ec.cloud.common.core.Context;
import com.cntaiping.ec.cloud.common.core.ContextUtils;
import com.cntaiping.ec.cloud.common.utils.id.UUID62;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;
import org.springframework.util.StringUtils;

public class TraceUtils {
    private static final ThreadLocal<String> TRACE_NO_THREAD_LOCAL = new InheritableThreadLocal<String>();
    public static final String IGNORE_TRACES = "Ignored_Trace";

    public static String get() {
        String traceNo = TRACE_NO_THREAD_LOCAL.get();
        if (traceNo != null) {
            return traceNo;
        }
        Context context = ContextUtils.get();
        if (context != null && (traceNo = context.getTraceNo()) != null) {
            return traceNo;
        }
        traceNo = TraceContext.traceId();
        if (!StringUtils.hasText((String)traceNo) || !TraceUtils.isRight(traceNo)) {
            traceNo = UUID62.randomUUID62();
        }
        return traceNo;
    }

    public static void set(String traceNo) {
        TRACE_NO_THREAD_LOCAL.set(traceNo);
    }

    public static void remove() {
        TRACE_NO_THREAD_LOCAL.remove();
    }

    public static boolean isRight(String traceNo) {
        return !IGNORE_TRACES.equals(traceNo);
    }
}

