/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.base;

import com.cntaiping.fsc.common.config.CommonProperties;
import com.cntaiping.fsc.core.dao.BaseDao;
import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.model.BaseResponse;
import com.cntaiping.fsc.core.model.Page;
import com.cntaiping.fsc.core.model.Pageable;
import com.cntaiping.fsc.core.service.BaseService;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.annotation.Transactional;

public abstract class GeneralService<T, PK extends Serializable, D extends BaseDao<T, PK>>
implements BaseService<T, PK> {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private CommonProperties commonProperties;
    @Autowired
    protected D dao;

    public T getPoById(PK paramPK) {
        Object t = this.dao.findById(paramPK);
        if (t != null) {
            return (T)t;
        }
        throw new TpcloudException(String.format("\u64cd\u4f5c\u5931\u8d25\uff0c\u4e3b\u5065\u3010%s\u3011\u5bf9\u5e94\u7684\u6570\u636e\u4e0d\u5b58\u5728\uff01", paramPK));
    }

    public BaseResponse<T> getById(PK paramPK) {
        return new BaseResponse("0000", this.dao.findById(paramPK));
    }

    @Transactional
    public BaseResponse<T> add(T paramT) {
        this.dao.save(paramT);
        return new BaseResponse("0000", paramT);
    }

    @Transactional
    public BaseResponse<String> adds(List<T> paramList) {
        int size;
        int threshold = this.commonProperties.getMaxInsertNumPerTime();
        int count = 0;
        if (size < threshold) {
            this.dao.saveList(paramList);
        } else {
            this.LOG.debug("\u6279\u91cf\u63d2\u5165\u6570\u91cf\u8d85\u8fc7\u9608\u503c[" + threshold + "]\uff0c\u5c06\u8fdb\u884c\u5206\u6279\u63d2\u5165\u3002\u5f53\u524d\u603b\u6570\u91cf\u4e3a\uff1a" + size);
            for (size = paramList.size(); size > 0; size -= threshold) {
                if (paramList.size() > threshold) {
                    List<T> subAppLogs = paramList.subList(0, threshold);
                    this.dao.saveList(subAppLogs);
                    subAppLogs.clear();
                    subAppLogs = null;
                } else {
                    this.dao.saveList(paramList);
                }
                ++count;
            }
            this.LOG.debug("\u5206\u6279\u63d2\u5165\u5b8c\u6210\u3002\u5904\u7406\u603b\u6570\u91cf\u4e3a\uff1a" + size + "\uff0c\u6279\u6b21\u6570\u91cf\u4e3a\uff1a" + count);
        }
        return new BaseResponse("0000", (Object)"SUCCESS");
    }

    @Transactional
    public BaseResponse<String> editById(PK id, T paramT) {
        this.dao.updateById(paramT);
        return new BaseResponse("0000", (Object)"SUCCESS");
    }

    @Transactional
    public BaseResponse<String> edit(T recordParamT, T conditionParamT) {
        this.dao.update(recordParamT, conditionParamT);
        return new BaseResponse("0000", (Object)"SUCCESS");
    }

    @Transactional
    public BaseResponse<String> deleteByIds(List<PK> paramPKs) {
        this.dao.deleteByIds(paramPKs);
        return new BaseResponse("0000", (Object)"SUCCESS");
    }

    public BaseResponse<List<T>> getlist(T paramT) {
        return new BaseResponse("0000", (Object)this.dao.findList(paramT));
    }

    public BaseResponse<Page<T>> getPage(T paramT, Pageable pageParam) {
        return new BaseResponse("0000", (Object)this.dao.findList(paramT, pageParam));
    }

    public BaseResponse<Page<T>> search(T paramT, Pageable pageParam) {
        return null;
    }

    @Transactional
    public BaseResponse<String> deleteById(PK id) {
        this.dao.deleteById(id);
        return new BaseResponse("0000", (Object)"SUCCESS");
    }
}

