/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.filter;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public class ResponseWrapper
extends HttpServletResponseWrapper {
    private ByteArrayOutputStream bytes;
    private HttpServletResponse response;
    private PrintWriter writer;

    public ResponseWrapper(HttpServletResponse response) throws UnsupportedEncodingException {
        super(response);
        this.response = response;
        this.bytes = new ByteArrayOutputStream();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new MyServletOutputStream(this.bytes);
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)this.bytes, StandardCharsets.UTF_8));
    }

    public byte[] getResult() throws IOException {
        if (null != this.writer) {
            this.writer.close();
            return this.bytes.toByteArray();
        }
        if (null != this.bytes) {
            this.bytes.flush();
            return this.bytes.toByteArray();
        }
        return this.bytes.toByteArray();
    }

    class MyServletOutputStream
    extends ServletOutputStream {
        private ByteArrayOutputStream stream;

        public MyServletOutputStream(ByteArrayOutputStream stream) {
            this.stream = stream;
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener writeListener) {
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }
    }
}

