/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.util.Assert;

public class DateUtil {
    public static Date parseToSpecificDate(Date date, int hour, int minute, int second) throws ParseException {
        Assert.isTrue((hour >= 0 && minute >= 0 && second >= 0 ? 1 : 0) != 0, (String)"Any of hour, minute, second can't be less than 0");
        Assert.isTrue((hour <= 24 ? 1 : 0) != 0, (String)"Hour can't be greater than 24");
        Assert.isTrue((minute <= 59 && second <= 59 ? 1 : 0) != 0, (String)"Minute and second can't be greater than 59");
        String timeString = " " + hour + ":" + minute + ":" + second;
        return DateUtil.parseWithStringTime(date, timeString);
    }

    private static Date parseWithStringTime(Date date, String timeString) throws ParseException {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String formattedDate = formatter.format(date) + timeString;
        return dateFormat.parse(formattedDate);
    }
}

