/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plus.config;

import com.baomidou.mybatisplus.autoconfigure.MybatisPlusInnerInterceptorAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.PostInitTableInfoHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.cntaiping.fsc.mybatis.base.MybatisInterceptorHelper;
import com.cntaiping.fsc.mybatis.plus.helper.TpPostInitTableInfoHandler;
import com.cntaiping.fsc.mybatis.plus.injector.TpDefaultSqlInjector;
import com.cntaiping.fsc.mybatis.plus.interceptor.TpMybatisPlusInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureBefore(value={MybatisPlusInnerInterceptorAutoConfiguration.class})
public class TpMybatisPlusAutoConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TpMybatisPlusAutoConfig.class);

    @Bean
    @ConditionalOnMissingBean
    public PostInitTableInfoHandler tpPostInitTableInfoHandler() {
        return new TpPostInitTableInfoHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public TpDefaultSqlInjector tpDefaultSqlInjector() {
        return new TpDefaultSqlInjector();
    }

    @Bean
    @Order(value=1)
    @ConditionalOnMissingBean
    public PaginationInnerInterceptor paginationInnerInterceptor() {
        return new PaginationInnerInterceptor();
    }

    @Bean
    @Order(value=10000)
    @ConditionalOnBean(value={InnerInterceptor.class})
    @ConditionalOnMissingBean(value={MybatisPlusInterceptor.class})
    public TpMybatisPlusInterceptor mybatisPlusInterceptor(MybatisInterceptorHelper mybatisInterceptorHelper, List<InnerInterceptor> innerInterceptorList) {
        LOGGER.info("TpMybatisPlusAutoConfig.mybatisPlusInterceptor creating..");
        TpMybatisPlusInterceptor mybatisPlusInterceptor = new TpMybatisPlusInterceptor(mybatisInterceptorHelper);
        mybatisPlusInterceptor.setInterceptors(innerInterceptorList);
        return mybatisPlusInterceptor;
    }
}

