/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plus.helper;

import com.baomidou.mybatisplus.core.handlers.PostInitTableInfoHandler;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.cntaiping.fsc.mybatis.plus.helper.TpTableInfo;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ibatis.mapping.ResultFlag;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.apache.ibatis.type.UnknownTypeHandler;

public class TpPostInitTableInfoHandler
implements PostInitTableInfoHandler {
    public TableInfo creteTableInfo(Configuration configuration, Class<?> entityType) {
        return new TpTableInfo(configuration, entityType);
    }

    public void postTableInfo(TableInfo tableInfo, Configuration configuration) {
        String namespace = tableInfo.getCurrentNamespace();
        configuration.addResultMap(this.createBaseResultMap(tableInfo, configuration));
        XNode baseColumnList = this.baseColumnList(tableInfo);
        configuration.getSqlFragments().put(namespace + ".Base_Column_List", baseColumnList);
        XNode baseSelectByEntityWhere = this.baseSelectByEntityWhere(tableInfo);
        configuration.getSqlFragments().put(namespace + ".Base_Select_By_Entity_Where", baseSelectByEntityWhere);
    }

    private XNode baseSelectByEntityWhere(TableInfo tableInfo) {
        String template = "<sql id=\"Base_Select_By_Entity_Where\">\n    <where>\n        {0}\n    </where>\n</sql>\n";
        String allSqlWhere = tableInfo.getAllSqlWhere(true, false, true, "");
        String xml = MessageFormat.format(template, allSqlWhere);
        return new XPathParser(xml).evalNode("/sql");
    }

    private XNode baseColumnList(TableInfo tableInfo) {
        String template = "<sql id=\"Base_Column_List\">\n    {0}\n</sql>\n";
        String xml = MessageFormat.format(template, tableInfo.getAllSqlSelect());
        return new XPathParser(xml).evalNode("/sql");
    }

    protected ResultMap createBaseResultMap(TableInfo tableInfo, Configuration configuration) {
        String id = tableInfo.getCurrentNamespace() + ".BaseResultMap";
        ArrayList<ResultMapping> resultMappings = new ArrayList<ResultMapping>();
        if (tableInfo.havePK()) {
            ResultMapping idMapping = new ResultMapping.Builder(configuration, tableInfo.getKeyProperty(), StringUtils.getTargetColumn((String)tableInfo.getKeyColumn()), tableInfo.getKeyType()).flags(Collections.singletonList(ResultFlag.ID)).build();
            resultMappings.add(idMapping);
        }
        if (CollectionUtils.isNotEmpty((Collection)tableInfo.getFieldList())) {
            tableInfo.getFieldList().stream().map(field -> this.createResultMapping(configuration, (TableFieldInfo)field)).forEach(resultMappings::add);
        }
        return new ResultMap.Builder(configuration, id, tableInfo.getEntityType(), resultMappings).build();
    }

    protected ResultMapping createResultMapping(Configuration configuration, TableFieldInfo field) {
        String property = field.getProperty();
        String column = field.getColumn();
        Class propertyType = field.getPropertyType();
        JdbcType jdbcType = field.getJdbcType();
        Class fieldTypeHandler = field.getTypeHandler();
        ResultMapping.Builder builder = new ResultMapping.Builder(configuration, property, StringUtils.getTargetColumn((String)column), propertyType);
        TypeHandlerRegistry registry = configuration.getTypeHandlerRegistry();
        if (jdbcType != null && jdbcType != JdbcType.UNDEFINED) {
            builder.jdbcType(jdbcType);
        }
        if (fieldTypeHandler != null && fieldTypeHandler != UnknownTypeHandler.class) {
            TypeHandler typeHandler = registry.getMappingTypeHandler(fieldTypeHandler);
            if (typeHandler == null) {
                typeHandler = registry.getInstance(propertyType, fieldTypeHandler);
            }
            builder.typeHandler(typeHandler);
        }
        return builder.build();
    }
}

