/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis;

import com.cntaiping.fsc.mybatis.JdbcTemplateDao;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public final class JdbcTemplateSupport
implements JdbcTemplateDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private JdbcTemplate jdbcTemplate;

    public JdbcTemplateSupport() {
    }

    public JdbcTemplateSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public Connection getConnnection() {
        DataSource dataSource = this.jdbcTemplate.getDataSource();
        if (dataSource != null) {
            try {
                return dataSource.getConnection();
            }
            catch (SQLException e) {
                this.logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public int[] batchUpdate(String[] sql) {
        return this.jdbcTemplate.batchUpdate(sql);
    }

    @Override
    public int[] batchUpdate(String sql, BatchPreparedStatementSetter pss) {
        return this.jdbcTemplate.batchUpdate(sql, pss);
    }

    @Override
    public List<Map<String, Object>> findBySQLWithParams(String SQL, Object[] parms) {
        return this.jdbcTemplate.queryForList(SQL, parms);
    }

    @Override
    public List findBySQLWithParams(String SQL, RowMapper rowMapper, Object[] parms) {
        return this.jdbcTemplate.query(SQL, rowMapper, parms);
    }

    @Override
    public Object findUnique(String SQL, Object[] parms, Class<?> calssT) {
        if (calssT == Map.class) {
            return this.jdbcTemplate.queryForMap(SQL, parms);
        }
        return this.jdbcTemplate.queryForObject(SQL, calssT, parms);
    }

    @Override
    public Object findUnique(String SQL, RowMapper rowMapper, Object[] parms) {
        return null;
    }
}

