/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.base;

import com.cntaiping.fsc.mybatis.base.DataPrivilegeOperator;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeRule;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class DataPrivilege
implements Serializable {
    private static final long serialVersionUID = 2113941703211428193L;
    private String dataPrivilegeId;
    private String apiResourceUrl;
    private String apiContextPath;
    private String apiResourceName;
    private String tableName;
    private String tableAlias;
    private String roleCode;
    private String userCode;
    private List<String> availableFieldNames;
    private List<DataPrivilegeOperator> availableOperators;
    private List<DataPrivilegeRule> dataPrivilegeRules;
    private boolean conformAllRule = true;
    private String dataPrivilegeSql;
    private String dataPrivilegeSqlWithAlias;

    public String getDataPrivilegeId() {
        return this.dataPrivilegeId;
    }

    public void setDataPrivilegeId(String dataPrivilegeId) {
        this.dataPrivilegeId = dataPrivilegeId;
    }

    public String getApiResourceUrl() {
        return this.apiResourceUrl;
    }

    public void setApiResourceUrl(String apiResourceUrl) {
        this.apiResourceUrl = apiResourceUrl;
    }

    public String getApiContextPath() {
        return this.apiContextPath;
    }

    public void setApiContextPath(String apiContextPath) {
        this.apiContextPath = apiContextPath;
    }

    public String getApiResourceName() {
        return this.apiResourceName;
    }

    public void setApiResourceName(String apiResourceName) {
        this.apiResourceName = apiResourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public void setTableAlias(String tableAlias) {
        this.tableAlias = tableAlias;
    }

    public String getRoleCode() {
        return this.roleCode;
    }

    public void setRoleCode(String roleCode) {
        this.roleCode = roleCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public List<String> getAvailableFieldNames() {
        return this.availableFieldNames;
    }

    public void setAvailableFieldNames(List<String> availableFieldNames) {
        this.availableFieldNames = availableFieldNames;
    }

    public List<DataPrivilegeOperator> getAvailableOperators() {
        return this.availableOperators;
    }

    public void setAvailableOperators(List<DataPrivilegeOperator> availableOperators) {
        this.availableOperators = availableOperators;
    }

    public List<DataPrivilegeRule> getDataPrivilegeRules() {
        if (this.dataPrivilegeRules == null) {
            this.dataPrivilegeRules = new ArrayList<DataPrivilegeRule>();
        }
        return this.dataPrivilegeRules;
    }

    public void setDataPrivilegeRules(List<DataPrivilegeRule> dataPrivilegeRules) {
        this.dataPrivilegeRules = dataPrivilegeRules;
        this.refreshDataPrivilegeSql();
    }

    public void addDataPrivilegeRules(DataPrivilegeRule dataPrivilegeRule) {
        if (this.dataPrivilegeRules == null) {
            this.dataPrivilegeRules = new ArrayList<DataPrivilegeRule>();
        }
        this.dataPrivilegeRules.add(dataPrivilegeRule);
        this.refreshDataPrivilegeSql();
    }

    public boolean isConformAllRule() {
        return this.conformAllRule;
    }

    public void setConformAllRule(boolean conformAllRule) {
        this.conformAllRule = conformAllRule;
    }

    public String getDataPrivilegeSql() {
        if (this.dataPrivilegeSql == null) {
            this.initDataPrivilegeSql();
        }
        return this.dataPrivilegeSql;
    }

    public void setDataPrivilegeSql(String dataPrivilegeSql) {
        this.dataPrivilegeSql = dataPrivilegeSql;
    }

    private void initDataPrivilegeSql() {
        if (this.dataPrivilegeRules != null && !this.dataPrivilegeRules.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            sb.append(" ( ");
            sb2.append(" ( ");
            for (int i = 0; i < this.dataPrivilegeRules.size(); ++i) {
                if (i > 0) {
                    sb.append(this.conformAllRule ? " and " : " or ");
                    sb2.append(this.conformAllRule ? " and " : " or ");
                }
                DataPrivilegeRule dataPrivilegeRule = this.dataPrivilegeRules.get(i);
                sb.append(dataPrivilegeRule.getSql());
                if (this.tableAlias == null || this.tableAlias.trim().equals("")) {
                    sb2.append(this.tableName + "_alias." + dataPrivilegeRule.getSql());
                    continue;
                }
                sb2.append(this.tableAlias + "." + dataPrivilegeRule.getSql());
            }
            sb.append(" )");
            sb2.append(" )");
            this.dataPrivilegeSql = sb.toString();
            this.dataPrivilegeSqlWithAlias = sb2.toString();
        }
    }

    private void refreshDataPrivilegeSql() {
        this.dataPrivilegeSql = null;
        this.initDataPrivilegeSql();
    }

    public String getDataPrivilegeSqlWithAlias() {
        if (this.dataPrivilegeSqlWithAlias == null) {
            this.initDataPrivilegeSql();
        }
        return this.dataPrivilegeSqlWithAlias;
    }

    public String getDataPrivilegeSqlWithAliasCust(String tableAlias) {
        if (tableAlias == null || tableAlias.trim().equals("")) {
            return this.getDataPrivilegeSql();
        }
        if (this.dataPrivilegeSqlWithAlias == null) {
            this.tableAlias = tableAlias;
            this.initDataPrivilegeSql();
        } else if (this.tableAlias == null) {
            this.dataPrivilegeSqlWithAlias = this.dataPrivilegeSqlWithAlias.replaceAll(this.tableName + "_alias", tableAlias);
        } else if (this.tableAlias != null && !this.tableAlias.equals(tableAlias)) {
            this.dataPrivilegeSqlWithAlias = this.dataPrivilegeSqlWithAlias.replaceAll(this.tableAlias, tableAlias);
        }
        return this.dataPrivilegeSqlWithAlias;
    }

    public void setDataPrivilegeSqlWithAlias(String dataPrivilegeSqlWithAlias) {
        this.dataPrivilegeSqlWithAlias = dataPrivilegeSqlWithAlias;
    }
}

