/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.base;

import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeOperator;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeRuleValueType;
import java.io.Serializable;

public class DataPrivilegeRule
implements Serializable {
    private static final long serialVersionUID = -275537605562491584L;
    private String tableName;
    private String fieldName;
    private String operator;
    private String[] values;
    private boolean noValue;
    private boolean singleValue;
    private boolean betweenValue;
    private boolean listValue;
    private String valueType;
    private String sql;

    public boolean isNoValue() {
        return this.noValue;
    }

    public boolean isSingleValue() {
        return this.singleValue;
    }

    public boolean isBetweenValue() {
        return this.betweenValue;
    }

    public boolean isListValue() {
        return this.listValue;
    }

    public DataPrivilegeRule() {
    }

    public DataPrivilegeRule(String tableName, String fieldName, DataPrivilegeOperator operator) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.operator = operator.getOperator();
        this.valueType = DataPrivilegeRuleValueType.Default.getValueType();
        this.noValue = true;
    }

    public DataPrivilegeRule(String tableName, String fieldName, DataPrivilegeOperator operator, String[] values, DataPrivilegeRuleValueType valueType) {
        this.tableName = tableName;
        this.fieldName = fieldName;
        this.operator = operator.getOperator();
        this.values = values;
        this.valueType = valueType.getValueType();
        if ((values == null || values.length == 0) && (operator.equals((Object)DataPrivilegeOperator.IsNull) || operator.equals((Object)DataPrivilegeOperator.IsNotNull))) {
            this.noValue = true;
        } else if (operator.equals((Object)DataPrivilegeOperator.In) || operator.equals((Object)DataPrivilegeOperator.NotIn)) {
            this.listValue = true;
        } else if (values.length == 1) {
            this.singleValue = true;
        } else if (values.length == 2 && (operator.equals((Object)DataPrivilegeOperator.Between) || operator.equals((Object)DataPrivilegeOperator.NotBetween))) {
            this.betweenValue = true;
        } else {
            throw new TpcloudException("Error in creating DataPrivilegeRule, reason: values length is " + values.length + ", but operator is " + operator.getOperator(), "0014");
        }
    }

    public String getSql() {
        if (this.sql == null) {
            this.initSql();
        }
        return this.sql;
    }

    private void initSql() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldName);
        sb.append(" ");
        sb.append(this.operator);
        if (!this.noValue) {
            if (this.singleValue) {
                if (this.valueType.equals(DataPrivilegeRuleValueType.Number.getValueType())) {
                    sb.append(" " + this.values[0]);
                } else {
                    sb.append(" '" + this.values[0] + "'");
                }
            } else if (this.betweenValue) {
                if (this.valueType.equals(DataPrivilegeRuleValueType.Number.getValueType())) {
                    sb.append(" " + this.values[0] + " and " + this.values[1]);
                } else {
                    sb.append(" '" + this.values[0] + "' and '" + this.values[1] + "'");
                }
            } else if (this.listValue) {
                sb.append("(");
                if (this.valueType.equals(DataPrivilegeRuleValueType.Number.getValueType())) {
                    for (String v : this.values) {
                        sb.append(v + ",");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                } else {
                    for (String v : this.values) {
                        sb.append("'" + v + "',");
                    }
                    sb.deleteCharAt(sb.length() - 1);
                }
                sb.append(")");
            }
        }
        this.sql = sb.toString();
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(DataPrivilegeOperator operator) {
        this.operator = operator.getOperator();
    }

    public String[] getValues() {
        return this.values;
    }

    public void setValues(String[] values) {
        this.values = values;
    }

    public String getValueType() {
        return this.valueType;
    }

    public void setValueType(DataPrivilegeRuleValueType valueType) {
        this.valueType = valueType.getValueType();
    }

    public void setNoValue(boolean noValue) {
        this.noValue = noValue;
    }

    public void setSingleValue(boolean singleValue) {
        this.singleValue = singleValue;
    }

    public void setBetweenValue(boolean betweenValue) {
        this.betweenValue = betweenValue;
    }

    public void setListValue(boolean listValue) {
        this.listValue = listValue;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }
}

