/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.base;

import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.fsc.mybatis.base.MybatisStatement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisInterceptorHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisInterceptorHelper.class);
    private final Map<String, MybatisStatement> map = new ConcurrentHashMap<String, MybatisStatement>();
    private static final MybatisStatement EMPTY = new MybatisStatement("$@EMTPY@$", null, null);

    public Optional<MybatisStatement> findMybatisStatement(String statementId) {
        MybatisStatement mybatisStatement = this.map.computeIfAbsent(statementId, this::loadMybatisStatement);
        if (mybatisStatement == EMPTY) {
            return Optional.empty();
        }
        return Optional.of(mybatisStatement);
    }

    private MybatisStatement loadMybatisStatement(String statementId) {
        if (Commons.isEmpty((Object)statementId)) {
            return EMPTY;
        }
        if (!statementId.contains(".")) {
            return EMPTY;
        }
        if (statementId.endsWith("!selectKey")) {
            return EMPTY;
        }
        try {
            int i = statementId.lastIndexOf(".");
            String type = statementId.substring(0, i);
            String methodName = statementId.substring(i + 1);
            Class mapperClass = ClassUtils.getClass((String)type, (boolean)false);
            Method method = Arrays.stream(mapperClass.getMethods()).filter(m -> m.getName().equals(methodName)).findAny().orElse(null);
            LOGGER.info("loadMybatisStatement {}#{}", (Object)type, (Object)methodName);
            return new MybatisStatement(statementId, mapperClass, method);
        }
        catch (ClassNotFoundException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return EMPTY;
        }
    }
}

