/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.cache;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V>
extends LinkedHashMap<K, V> {
    private final int maxSize;

    public LRUCache(int maxSize) {
        super(maxSize, 0.75f, true);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    public static void main(String[] args) {
        LRUCache<String, String> cache = new LRUCache<String, String>(3);
        cache.put("key1", "value1");
        cache.put("key2", "value2");
        cache.put("key3", "value3");
        System.out.println((String)cache.get("key1"));
        cache.put("key4", "value4");
        System.out.println((String)cache.get("key2"));
        System.out.println("cache.computeIfAbsent(\"key3\", \"value33\") = " + cache.computeIfAbsent("key3", k -> "value33"));
        System.out.println("cache = " + cache);
        System.out.println("cache.computeIfAbsent(\"key6\", \"value66\") = " + cache.computeIfAbsent("key6", k -> "value66"));
        System.out.println("cache = " + cache);
        System.out.println("cache.size() = " + cache.size());
    }
}

