/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.cache;

import com.cntaiping.fsc.mybatis.cache.RedisLruCache;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.decorators.LoggingCache;
import org.apache.ibatis.cache.decorators.LruCache;
import org.apache.ibatis.cache.decorators.ScheduledCache;
import org.apache.ibatis.cache.impl.PerpetualCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisCache
implements Cache {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String KEY = "MybatisCache2:";
    static RedisTemplate<String, Object> redisTemplate;
    private final String id;
    private final Cache localCache;

    public RedisCache(String id) {
        this.id = id;
        this.localCache = this.buildLocalCache(id);
    }

    private Cache buildLocalCache(String id) {
        ScheduledCache cache = new ScheduledCache((Cache)new LruCache((Cache)new PerpetualCache(this.id)));
        cache.setClearInterval(RedisLruCache.clearInterval);
        return new LoggingCache((Cache)cache);
    }

    public static void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        Assert.notNull(redisTemplate, (String)"Set RedisTemplate of RedisCache fail. RedisTemplate cannot be null!");
        RedisCache.redisTemplate = redisTemplate;
    }

    public String getId() {
        return this.id;
    }

    public int getSize() {
        return redisTemplate != null ? redisTemplate.opsForHash().size((Object)(KEY + this.id)).intValue() : this.localCache.getSize();
    }

    public void putObject(Object key, Object value) {
        if (redisTemplate != null) {
            redisTemplate.opsForHash().put((Object)(KEY + this.id), (Object)String.valueOf(((CacheKey)key).hashCode()), value);
        } else {
            this.localCache.putObject(key, value);
        }
    }

    public Object getObject(Object key) {
        return redisTemplate != null ? redisTemplate.opsForHash().get((Object)(KEY + this.id), (Object)String.valueOf(((CacheKey)key).hashCode())) : this.localCache.getObject(key);
    }

    public Object removeObject(Object key) {
        return redisTemplate != null ? redisTemplate.opsForHash().delete((Object)(KEY + this.id), new Object[]{String.valueOf(((CacheKey)key).hashCode())}) : this.localCache.removeObject(key);
    }

    public void clear() {
        if (redisTemplate != null) {
            redisTemplate.delete((Object)(KEY + this.id));
        } else {
            this.localCache.clear();
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return null;
    }

    public boolean equals(Object o) {
        if (this.getId() == null) {
            throw new CacheException("Redis Cache instances require an ID.");
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)o;
        return this.getId().equals(otherCache.getId());
    }

    public int hashCode() {
        if (this.getId() == null) {
            throw new CacheException("Redis Cache instances require an ID.");
        }
        return this.getId().hashCode();
    }
}

