/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.cache;

import com.cntaiping.fsc.mybatis.cache.RedisCache;
import com.cntaiping.fsc.mybatis.cache.RedisCacheStat;
import com.cntaiping.fsc.mybatis.cache.RedisLoggingCache;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.ibatis.cache.CacheKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisLruCache
extends RedisLoggingCache {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String LRU_KEY = "MybatisCacheLru2:";
    public static final String DATEFORMAT = "yyyyMMdd";
    public static final float MIN_HIT_RATIO = 0.2f;
    public static final float MIN_QUERY_RATIO = 0.5f;
    public static final int MIN_QUERY_THRESHOLD = 100;
    public static final int MAX_CREATE_THRESHOLD = 100;
    public static final int MAX_DELETE_THRESHOLD = 100;
    public static long clearInterval = TimeUnit.MINUTES.toSeconds(30L);
    public static long renewThreshold = clearInterval / 2L;
    public static int maxSize = 4096;
    public static int bound = 99;
    public static Random random = new Random();
    public static Date today = new Date();
    public static int STATS_RETENT_DAY = 30;
    private RedisCacheStat cacheStat;
    private long expireAt = 0L;
    private boolean enableCache = true;
    private String lruKey;

    public RedisLruCache(String id) {
        super(id);
        this.cacheStat = new RedisCacheStat(id, new Date());
        this.lruKey = LRU_KEY + id;
    }

    public synchronized int getSize() {
        return this.delegate.getSize();
    }

    public synchronized void putObject(Object key, Object value) {
        if (RedisCache.redisTemplate != null && this.enableRedisCache(this.delegate.getId())) {
            this.delegate.putObject(key, value);
            this.updateLruCacheStats((CacheKey)key);
            this.updateCacheExpireTime(this.delegate.getId());
            this.removeEldestCache(key);
        }
        this.updateCreateOpsCount();
    }

    @Override
    public synchronized Object getObject(Object key) {
        Object value = null;
        boolean hitCache = false;
        if (RedisCache.redisTemplate != null && this.enableRedisCache(this.delegate.getId())) {
            value = this.delegate.getObject(key);
            if (value != null) {
                hitCache = true;
            } else {
                this.LOG.debug("Create New Redis Cache for [" + this.getId() + "]: " + ((CacheKey)key).hashCode());
            }
            this.updateLruCacheStats((CacheKey)key);
            this.updateCacheExpireTime(this.delegate.getId());
        }
        this.updateHitRatio(hitCache);
        return value;
    }

    public synchronized Object removeObject(Object key) {
        this.updateDeleteOpsCount();
        return this.delegate.removeObject(key);
    }

    public synchronized void clear() {
        this.updateDeleteOpsCount();
        if (RedisCache.redisTemplate != null) {
            RedisCache.redisTemplate.delete((Object)(LRU_KEY + this.delegate.getId()));
        }
        this.delegate.clear();
    }

    private void removeEldestCache(Object key) {
        if (this.delegate.getSize() >= maxSize) {
            Set keys = RedisCache.redisTemplate.opsForZSet().range((Object)(LRU_KEY + this.delegate.getId()), 0L, (long)bound);
            RedisCache.redisTemplate.opsForHash().delete((Object)("MybatisCache2:" + this.delegate.getId()), keys.toArray());
            RedisCache.redisTemplate.opsForZSet().removeRange((Object)(LRU_KEY + this.delegate.getId()), 0L, (long)bound);
        }
    }

    private void updateCacheExpireTime(String id) {
        this.expireAt = RedisCache.redisTemplate.getExpire((Object)("MybatisCache2:" + id));
        if (this.expireAt <= 0L || this.expireAt < renewThreshold) {
            this.expireAt = clearInterval;
            RedisCache.redisTemplate.expire((Object)("MybatisCache2:" + id), clearInterval, TimeUnit.SECONDS);
            RedisCache.redisTemplate.expire((Object)(LRU_KEY + id), clearInterval, TimeUnit.SECONDS);
        }
    }

    private boolean isNewStatPeriod(String id) {
        Date today = new Date();
        if (this.cacheStat == null || !DateUtils.isSameDay((Date)today, (Date)this.cacheStat.getPeriod())) {
            this.cacheStat = new RedisCacheStat(id, today);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHitRatio(boolean hitCache) {
        RedisCacheStat redisCacheStat = this.cacheStat;
        synchronized (redisCacheStat) {
            this.cacheStat.incrQueryOpsCount();
            if (hitCache) {
                this.cacheStat.incrHitCount();
            }
        }
        this.LOG.debug("Redis Cache Stat [{}]: HitRatio: {}, QueryRatio: {}", new Object[]{this.getId(), this.cacheStat.getHitRatio(), this.cacheStat.getQueryRatio()});
    }

    private boolean enableRedisCache(String id) {
        if (!this.isNewStatPeriod(id) && this.cacheStat.getQueryRatio() < 0.5) {
            if (this.enableCache && this.cacheStat.getQueryOpsCount() > 100 && this.isLowHitRatio()) {
                this.LOG.warn("Redis Cache is disable for [{}], HitRatio: {}", (Object)this.getId(), (Object)this.cacheStat.getHitRatio());
                this.enableCache = false;
                this.clear();
            }
        } else if (!this.enableCache) {
            this.enableCache = true;
        }
        return this.enableCache;
    }

    private boolean isLowHitRatio() {
        return this.cacheStat.getHitRatio() < (double)0.2f;
    }

    private void updateDeleteOpsCount() {
        if (!this.isNewStatPeriod(this.delegate.getId())) {
            this.cacheStat.incrDeleteOpsCount();
        }
    }

    private void updateCreateOpsCount() {
        if (!this.isNewStatPeriod(this.delegate.getId())) {
            this.cacheStat.incrCreateOpsCount();
        }
    }

    private void updateLruCacheStats(CacheKey key) {
        if (RedisCache.redisTemplate.hasKey((Object)this.lruKey).booleanValue()) {
            RedisCache.redisTemplate.opsForZSet().incrementScore((Object)this.lruKey, (Object)String.valueOf(key.hashCode()), 1.0);
        } else {
            RedisCache.redisTemplate.opsForZSet().add((Object)this.lruKey, (Object)String.valueOf(key.hashCode()), 0.0);
        }
    }
}

