/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.config;

import brave.Tracer;
import com.cntaiping.fsc.mybatis.base.MybatisInterceptorHelper;
import com.cntaiping.fsc.mybatis.cache.RedisCache;
import com.cntaiping.fsc.mybatis.config.MybatisCustomConfig;
import com.cntaiping.fsc.mybatis.config.MybatisCustomProperties;
import com.cntaiping.fsc.mybatis.dialect.MySQLDialect;
import com.cntaiping.fsc.mybatis.dialect.OracleDialect;
import com.cntaiping.fsc.mybatis.dialect.PostgreSQLDialect;
import com.cntaiping.fsc.mybatis.plugin.MybatisOperateInterceptor;
import com.cntaiping.fsc.mybatis.plugin.MybatisPageableInterceptor;
import com.cntaiping.fsc.mybatis.util.BizNoUtil;
import com.cntaiping.fsc.mybatis.util.DataPrivilegeUtil;
import javax.sql.DataSource;
import org.mybatis.spring.annotation.MapperScan;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.util.StringUtils;

@Configuration
@EnableTransactionManagement
@EnableConfigurationProperties(value={MybatisProperties.class})
@AutoConfigureAfter(value={MybatisCustomConfig.class, RedisAutoConfiguration.class, MybatisAutoConfiguration.class})
@MapperScan(basePackages={"${mybatis.basePackage:com.cntaiping.**.dao}"})
public class MybatisConfig
implements InitializingBean {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DataSource dataSource;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataSourceProperties dataSourceProperties;
    @Autowired
    private MybatisProperties mybatisProperties;
    @Autowired
    private MybatisCustomProperties mybatisCustomProperties;
    @Autowired
    private RedisTemplate<String, Object> jsonRedisTemplate;
    @Autowired
    protected Tracer tracer;

    public MybatisConfig() {
        this.LOG.debug("Init MybatisConfig.");
    }

    @Bean
    @ConditionalOnMissingBean
    public MybatisInterceptorHelper mybatisInterceptorHelper() {
        return new MybatisInterceptorHelper();
    }

    @Bean(value={"mybatisPageableInterceptor"})
    public MybatisPageableInterceptor mybatisPageableInterceptor(MybatisInterceptorHelper mybatisInterceptorHelper) {
        MybatisPageableInterceptor mybatisPageableInterceptor = new MybatisPageableInterceptor();
        mybatisPageableInterceptor.setMybatisInterceptorHelper(mybatisInterceptorHelper);
        mybatisPageableInterceptor.setJsonRedisTemplate(this.jsonRedisTemplate);
        mybatisPageableInterceptor.setMybatisCustomProperties(this.mybatisCustomProperties);
        mybatisPageableInterceptor.setTracer(this.tracer);
        String dBDriverClassName = this.dataSourceProperties.getDriverClassName();
        if (!StringUtils.hasText((String)dBDriverClassName)) {
            dBDriverClassName = this.dataSourceProperties.determineDriverClassName();
        }
        if (dBDriverClassName.contains("postgre")) {
            mybatisPageableInterceptor.setDialect(new PostgreSQLDialect());
        } else if (dBDriverClassName.contains("oracle")) {
            mybatisPageableInterceptor.setDialect(new OracleDialect());
        } else if (dBDriverClassName.contains("mysql") || dBDriverClassName.contains("mariadb")) {
            mybatisPageableInterceptor.setDialect(new MySQLDialect());
        } else {
            this.LOG.error("Unsupport Database driver  [" + dBDriverClassName + "]");
            throw new IllegalArgumentException("Unsupport Database driver [" + dBDriverClassName + "]");
        }
        this.LOG.debug("Init mybatisPageableInterceptor. Current Database driver is [" + dBDriverClassName + "]");
        return mybatisPageableInterceptor;
    }

    @Bean(value={"mybatisOptimisticLockInterceptor"})
    public MybatisOperateInterceptor mybatisOptimisticLockInterceptor(MybatisInterceptorHelper mybatisInterceptorHelper) {
        MybatisOperateInterceptor mybatisOperateInterceptor = new MybatisOperateInterceptor();
        mybatisOperateInterceptor.setMybatisInterceptorHelper(mybatisInterceptorHelper);
        mybatisOperateInterceptor.setMybatisCustomProperties(this.mybatisCustomProperties);
        mybatisOperateInterceptor.setTracer(this.tracer);
        this.LOG.debug("Init mybatisOperateInterceptor.");
        return mybatisOperateInterceptor;
    }

    @Bean(value={"transactionManager"})
    public PlatformTransactionManager transactionManager() {
        this.LOG.debug("Init MybatisConfig transactionManager: datasource type[{}]", (Object)this.dataSource.getClass().getName());
        return new DataSourceTransactionManager(this.dataSource);
    }

    @Bean
    public BizNoUtil bizNoUtil() {
        this.LOG.debug("Init MybatisConfig BizNoUtil.");
        return new BizNoUtil(this.jsonRedisTemplate, this.jdbcTemplate, 50);
    }

    @Bean(value={"dataPrivilegeUtil"})
    @ConditionalOnProperty(value={"mybatis.custom.enableDataPrivilege"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnMissingBean(value={DataPrivilegeUtil.class})
    public DataPrivilegeUtil dataPrivilegeUtil() {
        this.LOG.debug("Init MybatisConfig DataPrivilegeUtil.");
        return new DataPrivilegeUtil(this.jdbcTemplate, this.jsonRedisTemplate);
    }

    public void afterPropertiesSet() throws Exception {
        RedisCache.setRedisTemplate(this.jsonRedisTemplate);
    }
}

