/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.dialect;

import com.cntaiping.fsc.mybatis.dialect.AbstractDialect;
import java.util.Iterator;
import org.springframework.data.domain.Sort;

public class OracleDialect
extends AbstractDialect {
    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public String getLimitString(String sql, long offset, String offsetPlaceholder, int limit, String limitPlaceholder) {
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 100);
        if (offset > 0L) {
            pagingSelect.append("select * from ( select row_.*, rownum as rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (offset > 0L) {
            pagingSelect.append(" ) row_ where rownum <= " + (offset + (long)limit) + " ) where rownum_ > " + offset);
        } else {
            pagingSelect.append(" ) where rownum <= " + limit);
        }
        return pagingSelect.toString();
    }

    @Override
    public String getSortString(String sql, Sort sort) {
        if (sort == null) {
            return sql;
        }
        if ((sql = sql.trim()).toUpperCase().endsWith(" FOR UPDATE")) {
            sql = sql.substring(0, sql.length() - 11);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        if (sort != null) {
            Iterator orders = sort.iterator();
            sb.append(" ORDER BY ");
            boolean first = true;
            while (orders.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Sort.Order order = (Sort.Order)orders.next();
                sb.append(order.getProperty());
                sb.append(" ");
                sb.append(order.getDirection());
            }
        }
        return sb.toString();
    }
}

