/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.dialect;

import com.cntaiping.fsc.mybatis.dialect.AbstractDialect;
import java.util.Iterator;
import org.springframework.data.domain.Sort;

public class PostgreSQLDialect
extends AbstractDialect {
    @Override
    public boolean supportsLimitOffset() {
        return true;
    }

    @Override
    public boolean supportsLimit() {
        return true;
    }

    @Override
    public String getLimitString(String sql, long offset, String offsetPlaceholder, int limit, String limitPlaceholder) {
        if (offset > 0L) {
            return sql + " limit " + limitPlaceholder + " offset " + offsetPlaceholder;
        }
        return sql + " limit " + limitPlaceholder;
    }

    @Override
    public String getSortString(String sql, Sort sort) {
        if (sort == null) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql);
        if (sort != null) {
            Iterator orders = sort.iterator();
            sb.append(" ORDER BY ");
            boolean first = true;
            while (orders.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                Sort.Order order = (Sort.Order)orders.next();
                sb.append(order.getProperty());
                sb.append(" ");
                sb.append(order.getDirection());
            }
        }
        return sb.toString();
    }
}

