/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.internal;

import com.alibaba.fastjson.JSON;
import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.util.JexlMap;
import com.cntaiping.fsc.mybatis.model.GgSequenceGroupVo;
import com.cntaiping.fsc.mybatis.model.GgSequenceVo;
import java.util.Map;
import java.util.Random;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlExpression;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;

public class BusinessNoGenerator {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final String UPDATE_SEQ_SQL = "update GG_SEQUENCE SET CURRENT_NO = ?, MAX_CACHE_NO = ? where SEQUENCE_ID = ?";
    private static final String UPDATE_GROUP_SEQ_SQL = "update GG_SEQUENCE_GROUP SET CURRENT_NO = ?, MAX_CACHE_NO = ? where SEQ_GROUP_CODE = ?";
    private static final String INSERT_GROUP_SEQ_SQL = "insert into GG_SEQUENCE_GROUP (seq_group_code, sequence_id, seq_no_length, current_no, cache_size, max_cache_no) values (?, ?, ?, ?, ?, ?)";
    private StringBuilder seqNoBuilder = new StringBuilder();
    private RedisTemplate<String, Object> redisTemplate;
    private JdbcTemplate jdbcTemplate;
    private Random random;
    private JexlEngine jexl;

    public BusinessNoGenerator(RedisTemplate<String, Object> redisTemplate, JdbcTemplate jdbcTemplate, int jexlCacheSize) {
        Assert.notNull(redisTemplate, (String)"RedisTemplate can not be null when init RedisSequenceUtil!");
        Assert.notNull((Object)jdbcTemplate, (String)"JdbcTemplate can not be null when init RedisSequenceUtil!");
        this.redisTemplate = redisTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.random = new Random();
        JexlBuilder jb = new JexlBuilder();
        jb.cache(jexlCacheSize);
        jb.silent(false);
        jb.strict(true);
        this.jexl = jb.create();
    }

    private void updateSeqNoInternal(String sequenceId, GgSequenceVo config) {
        long newMaxNo = config.getCurrentNo() + 1L;
        if (config.getMaxCacheNo() < newMaxNo) {
            config.setMaxCacheNo(config.getCurrentNo() + (long)config.getCacheSize().intValue());
            this.jdbcTemplate.update(UPDATE_SEQ_SQL, new Object[]{newMaxNo, config.getMaxCacheNo(), config.getSequenceId()});
        }
        config.setCurrentNo(newMaxNo);
        this.redisTemplate.opsForHash().put((Object)"GG_SEQUENCE_NO", (Object)sequenceId, (Object)JSON.toJSONString((Object)config));
        this.LOG.debug("\u66f4\u65b0\u5e8f\u5217\u53f7[{}]\uff0c\u4e0b\u6b21\u53ef\u7528\u53f7\u7801\u4e3a\uff1a{}, \u7f13\u5b58\u4e2d\u6700\u5927\u53ef\u7528\u53f7\u7801\u4e3a\uff1a{}", new Object[]{sequenceId, newMaxNo, config.getMaxCacheNo()});
    }

    private void updateGroupSeqNoInternal(String sequenceId, String seqGroupCode, GgSequenceGroupVo groupInfo) {
        long newMaxNo = groupInfo.getCurrentNo() + 1L;
        if (groupInfo.getMaxCacheNo() < newMaxNo) {
            groupInfo.setMaxCacheNo(groupInfo.getCurrentNo() + (long)groupInfo.getCacheSize().intValue());
            this.jdbcTemplate.update(UPDATE_SEQ_SQL, new Object[]{newMaxNo, groupInfo.getMaxCacheNo(), groupInfo.getSequenceId()});
            this.jdbcTemplate.update(UPDATE_GROUP_SEQ_SQL, new Object[]{newMaxNo, groupInfo.getMaxCacheNo(), groupInfo.getSeqGroupCode()});
        }
        groupInfo.setCurrentNo(newMaxNo);
        this.redisTemplate.opsForHash().put((Object)("GG_SEQ_GROUP:" + sequenceId), (Object)seqGroupCode, (Object)JSON.toJSONString((Object)groupInfo));
        this.LOG.debug("\u66f4\u65b0\u5e8f\u5217\u53f7[{}]\uff0c\u5206\u7ec4\u7f16\u7801\uff1a{}\uff0c\u4e0b\u6b21\u53ef\u7528\u53f7\u7801\u4e3a\uff1a{}, \u7f13\u5b58\u4e2d\u6700\u5927\u53ef\u7528\u53f7\u7801\u4e3a\uff1a{}", new Object[]{sequenceId, seqGroupCode, newMaxNo, groupInfo.getMaxCacheNo()});
    }

    private GgSequenceGroupVo getGgSequenceGroupInfo(String sequenceId, String seqGroupCode, GgSequenceVo config) {
        Object jsonStr;
        GgSequenceGroupVo groupInfo = null;
        String redisGroupKey = "GG_SEQ_GROUP:" + sequenceId;
        if (this.redisTemplate.hasKey((Object)redisGroupKey).booleanValue() && (jsonStr = this.redisTemplate.opsForHash().get((Object)redisGroupKey, (Object)seqGroupCode)) != null) {
            groupInfo = (GgSequenceGroupVo)JSON.parseObject((String)((String)jsonStr), GgSequenceGroupVo.class);
        }
        if (groupInfo == null) {
            groupInfo = new GgSequenceGroupVo();
            groupInfo.setSeqGroupCode(seqGroupCode);
            groupInfo.setSequenceId(sequenceId);
            groupInfo.setCacheSize(config.getCacheSize());
            groupInfo.setCurrentNo(1L);
            groupInfo.setMaxCacheNo((long)config.getCacheSize());
            groupInfo.setSeqNoLength(config.getSeqNoLength());
            this.jdbcTemplate.update(INSERT_GROUP_SEQ_SQL, new Object[]{seqGroupCode, sequenceId, groupInfo.getSeqNoLength(), groupInfo.getCurrentNo(), groupInfo.getCacheSize(), groupInfo.getMaxCacheNo()});
            this.redisTemplate.opsForHash().put((Object)redisGroupKey, (Object)seqGroupCode, (Object)JSON.toJSONString((Object)groupInfo));
        }
        return groupInfo;
    }

    public Object createSeqNoInternal(String sequenceId, Map<String, Object> paramMap) {
        if (this.redisTemplate.hasKey((Object)"GG_SEQUENCE_NO").booleanValue()) {
            if (this.redisTemplate.opsForHash().hasKey((Object)"GG_SEQUENCE_NO", (Object)sequenceId).booleanValue()) {
                Object jsonStr = this.redisTemplate.opsForHash().get((Object)"GG_SEQUENCE_NO", (Object)sequenceId);
                if (jsonStr != null) {
                    GgSequenceVo config = (GgSequenceVo)JSON.parseObject((String)((String)jsonStr), GgSequenceVo.class);
                    Long currentMaxNo = 1L;
                    Short seqNoLength = config.getSeqNoLength();
                    if (config.getSeqNoType() == 0) {
                        currentMaxNo = config.getCurrentNo();
                        this.updateSeqNoInternal(sequenceId, config);
                        return currentMaxNo;
                    }
                    String jexlRule = config.getSequenceRule();
                    JexlMap jexlContext = new JexlMap(paramMap);
                    JexlExpression jexlExpr = this.jexl.createExpression(jexlRule);
                    String seqNo = null;
                    String result = null;
                    if (StringUtils.isNotBlank((CharSequence)jexlRule)) {
                        result = (String)jexlExpr.evaluate((JexlContext)jexlContext);
                        String seqGroupCode = null;
                        GgSequenceGroupVo groupInfo = null;
                        if (config.getIncreaseType() == 4) {
                            seqGroupCode = result;
                            groupInfo = this.getGgSequenceGroupInfo(sequenceId, seqGroupCode, config);
                            currentMaxNo = groupInfo.getCurrentNo();
                        } else {
                            currentMaxNo = config.getCurrentNo();
                        }
                        seqNo = this.generateSequenceNum(currentMaxNo, seqNoLength);
                        result = result.replace("SEQ_NO", seqNo);
                        this.LOG.debug("\u5e8f\u5217\u53f7[{}]\uff0c\u589e\u957f\u65b9\u5f0f\uff1a{}\uff0c\u751f\u6210\u65b0\u5355\u53f7:{}", new Object[]{sequenceId, config.getIncreaseType(), result});
                        if (config.getIncreaseType() == 4) {
                            this.updateGroupSeqNoInternal(sequenceId, seqGroupCode, groupInfo);
                        } else {
                            this.updateSeqNoInternal(sequenceId, config);
                        }
                        return result;
                    }
                    throw new TpcloudException(String.format("\u5e8f\u5217\u53f7[%s]\u751f\u6210\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u4e3a\u9519\u8bef\uff0c\u89c4\u5219\u8868\u8fbe\u5f0f\u4e3a\u7a7a\uff01", sequenceId), "0017");
                }
                throw new TpcloudException(String.format("\u5e8f\u5217\u53f7[%s]\u751f\u6210\u89c4\u5219\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff01", sequenceId), "0007");
            }
            throw new TpcloudException("\u5e8f\u5217\u53f7\u751f\u6210\u89c4\u5219\u672a\u914d\u7f6e\uff01sequenceId: " + sequenceId, "0007");
        }
        throw new TpcloudException("\u5e8f\u5217\u53f7\u751f\u6210\u89c4\u5219\u672a\u521d\u59cb\u5316\uff01", "0007");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateRandomdNum(int length) {
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"length must be greater than 0!");
        String sequencStr = null;
        StringBuilder stringBuilder = this.seqNoBuilder;
        synchronized (stringBuilder) {
            for (int i = 0; i < length; ++i) {
                this.seqNoBuilder.append(this.random.nextInt(9));
            }
            sequencStr = this.seqNoBuilder.toString();
            this.seqNoBuilder.setLength(0);
        }
        return sequencStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSequenceNum(long currentMaxNo, short length) {
        Assert.isTrue((currentMaxNo > 0L ? 1 : 0) != 0, (String)"currentMaxNo must be greater than 0!");
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"length must be greater than 0!");
        String sequencStr = "";
        int prefixLength = 0;
        StringBuilder stringBuilder = this.seqNoBuilder;
        synchronized (stringBuilder) {
            sequencStr = String.valueOf(currentMaxNo);
            prefixLength = length - sequencStr.length();
            if (prefixLength >= 0) {
                for (int i = 0; i < prefixLength; ++i) {
                    this.seqNoBuilder.append("0");
                }
            } else {
                throw new TpcloudException("\u751f\u6210\u5355\u53f7\u5931\u8d25\uff0c\u9700\u8981\u4f7f\u7528\u7684\u5e8f\u53f7[" + currentMaxNo + "]\u5df2\u7ecf\u8d85\u8fc7\u6700\u5927\u53ef\u7528\u5e8f\u53f7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u589e\u52a0\u5e8f\u53f7\u957f\u5ea6\u3002");
            }
            this.seqNoBuilder.append(sequencStr);
            sequencStr = this.seqNoBuilder.toString();
            this.seqNoBuilder.setLength(0);
        }
        return sequencStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSequenceNum2(long currentMaxNo, short length) {
        Assert.isTrue((currentMaxNo > 0L ? 1 : 0) != 0, (String)"currentMaxNo must be greater than 0!");
        Assert.isTrue((length > 0 ? 1 : 0) != 0, (String)"length must be greater than 0!");
        Assert.isTrue((length < 13 ? 1 : 0) != 0, (String)"length can not be greater than 12!");
        String sequencStr = "";
        StringBuilder stringBuilder = this.seqNoBuilder;
        synchronized (stringBuilder) {
            this.seqNoBuilder.append("00000000000");
            this.seqNoBuilder.append(String.valueOf(currentMaxNo));
            sequencStr = this.seqNoBuilder.toString();
            this.seqNoBuilder.setLength(0);
        }
        return sequencStr.substring(sequencStr.length() - length, sequencStr.length());
    }
}

