/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plugin;

import brave.Tracer;
import com.cntaiping.fsc.mybatis.base.MybatisInterceptorHelper;
import com.cntaiping.fsc.mybatis.base.MybatisStatement;
import com.cntaiping.fsc.mybatis.config.MybatisCustomProperties;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.lang3.ClassUtils;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseMybatisInterceptor
implements Interceptor {
    public static final String PLUS_MAPPER = "com.cntaiping.fsc.mybatis.plus.TpPlusDao";
    protected static final boolean MYBATIS_PLUS_EXISTS;
    protected static final Class<?> PLUS_MAPPER_CLASS;
    protected Logger LOG = LoggerFactory.getLogger(this.getClass());
    protected static int MAPPED_STATEMENT_INDEX;
    protected static int PARAMETER_INDEX;
    protected static int ROWBOUNDS_INDEX;
    protected static int RESULT_HANDLER_INDEX;
    protected static final String RSN = "Mybatis";
    protected static final String DAOINX = "dao.";
    protected static final String DAOMETHOD = "daoMethod";
    protected MybatisCustomProperties properties;
    protected MybatisInterceptorHelper mybatisInterceptorHelper;
    protected Tracer tracer;

    protected String removeBreakingWhitespace(String original) {
        StringTokenizer whitespaceStripper = new StringTokenizer(original);
        StringBuilder builder = new StringBuilder();
        while (whitespaceStripper.hasMoreTokens()) {
            builder.append(whitespaceStripper.nextToken());
            builder.append(" ");
        }
        return builder.toString();
    }

    protected String setParametersToSql(String customSql, MappedStatement mappedStatement, BoundSql boundSql) {
        TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
        Configuration configuration = mappedStatement.getConfiguration();
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterMappings != null) {
            for (int i = 0; i < parameterMappings.size(); ++i) {
                Object value;
                ParameterMapping parameterMapping = (ParameterMapping)parameterMappings.get(i);
                if (parameterMapping.getMode() == ParameterMode.OUT) continue;
                String propertyName = parameterMapping.getProperty();
                if (boundSql.hasAdditionalParameter(propertyName)) {
                    value = boundSql.getAdditionalParameter(propertyName);
                } else if (parameterObject == null) {
                    value = null;
                } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                    value = parameterObject;
                } else {
                    MetaObject metaObject = configuration.newMetaObject(parameterObject);
                    value = metaObject.getValue(propertyName);
                }
                Object strValue = null;
                strValue = value instanceof String || value instanceof Date ? "'" + value + "'" : (value == null ? "null" : value.toString());
                int index = customSql.indexOf(63);
                if (index <= 0) continue;
                customSql = customSql.replaceFirst("\\?", (String)strValue);
            }
        }
        return customSql;
    }

    protected CacheKey createCountResultCacheKey(MappedStatement ms, BoundSql boundSql) {
        CacheKey cacheKey = new CacheKey();
        cacheKey.update((Object)ms.getId());
        cacheKey.update((Object)boundSql.getSql());
        List parameterMappings = boundSql.getParameterMappings();
        TypeHandlerRegistry typeHandlerRegistry = ms.getConfiguration().getTypeHandlerRegistry();
        Configuration configuration = ms.getConfiguration();
        Object parameterObject = boundSql.getParameterObject();
        for (ParameterMapping parameterMapping : parameterMappings) {
            Object value;
            if (parameterMapping.getMode() == ParameterMode.OUT) continue;
            String propertyName = parameterMapping.getProperty();
            if (boundSql.hasAdditionalParameter(propertyName)) {
                value = boundSql.getAdditionalParameter(propertyName);
            } else if (parameterObject == null) {
                value = null;
            } else if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                value = parameterObject;
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                value = metaObject.getValue(propertyName);
            }
            cacheKey.update(value);
        }
        return cacheKey;
    }

    protected boolean isBaseDaoPlus(String msId) {
        MybatisStatement mybatisStatement = this.mybatisInterceptorHelper.findMybatisStatement(msId).orElse(null);
        if (mybatisStatement == null) {
            return false;
        }
        return mybatisStatement.isSubOf(PLUS_MAPPER_CLASS);
    }

    public MybatisCustomProperties getMybatisCustomProperties() {
        return this.properties;
    }

    public void setMybatisCustomProperties(MybatisCustomProperties mybatisCustomProperties) {
        this.properties = mybatisCustomProperties;
    }

    public void setTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public MybatisInterceptorHelper getMybatisInterceptorHelper() {
        return this.mybatisInterceptorHelper;
    }

    public void setMybatisInterceptorHelper(MybatisInterceptorHelper mybatisInterceptorHelper) {
        this.mybatisInterceptorHelper = mybatisInterceptorHelper;
    }

    static {
        boolean mybatisPlusExists;
        Class plusMapper;
        try {
            plusMapper = ClassUtils.getClass((String)PLUS_MAPPER, (boolean)false);
            mybatisPlusExists = true;
        }
        catch (ClassNotFoundException e) {
            plusMapper = null;
            mybatisPlusExists = false;
        }
        MYBATIS_PLUS_EXISTS = mybatisPlusExists;
        PLUS_MAPPER_CLASS = plusMapper;
        MAPPED_STATEMENT_INDEX = 0;
        PARAMETER_INDEX = 1;
        ROWBOUNDS_INDEX = 2;
        RESULT_HANDLER_INDEX = 3;
    }
}

