/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plugin;

import brave.Span;
import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.mybatis.plugin.BaseMybatisInterceptor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.springframework.core.Ordered;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisOperateInterceptor
extends BaseMybatisInterceptor
implements Ordered {
    public static final int ORDER = 20000;

    public Object intercept(Invocation inv) throws Throwable {
        Object[] queryArgs = inv.getArgs();
        MappedStatement ms = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        String id = ms.getId();
        Span span = this.tracer.nextSpan().name(id.substring(id.lastIndexOf("dao.") + "dao.".length()));
        this.LOG.debug("SQL type:{}, id: {}", (Object)ms.getSqlCommandType(), (Object)id);
        span.remoteServiceName("Mybatis");
        span.kind(Span.Kind.CLIENT);
        span.tag("daoMethod", id);
        span.start();
        Object result = null;
        switch (ms.getSqlCommandType()) {
            case UPDATE: {
                result = this.doUpdateSQL(inv, queryArgs);
                break;
            }
            case INSERT: {
                result = this.doInsertSQL(inv, queryArgs);
                break;
            }
            default: {
                result = inv.proceed();
            }
        }
        this.LOG.debug("SQL Affected Size: {}", result);
        span.finish();
        return result;
    }

    private Object doInsertSQL(Invocation inv, Object[] queryArgs) throws Throwable {
        if (this.properties.isEnableMybatisAuditing()) {
            queryArgs[MybatisOperateInterceptor.PARAMETER_INDEX] = this.resetInsertParameter(queryArgs[PARAMETER_INDEX]);
            return inv.getMethod().invoke(inv.getTarget(), queryArgs);
        }
        return inv.proceed();
    }

    private Object doUpdateSQL(Invocation inv, Object[] queryArgs) throws Throwable {
        Object result = null;
        if (this.properties.isEnableMybatisAuditing()) {
            queryArgs[MybatisOperateInterceptor.PARAMETER_INDEX] = this.resetUpdateParameter(queryArgs[PARAMETER_INDEX]);
            result = inv.getMethod().invoke(inv.getTarget(), queryArgs);
        } else {
            result = inv.proceed();
        }
        if (result instanceof Integer) {
            if ((Integer)result == 0) {
                throw new TpcloudException("Data update failure, because of version conflict or no such data.", "0014");
            }
            this.LOG.debug("Data update finish. Affected size : " + result);
        }
        return result;
    }

    private void initParamField(Object param, Class<?> clazz, String fieldName, Object value, boolean override) {
        try {
            Field paramField = clazz.getDeclaredField(fieldName);
            paramField.setAccessible(true);
            if (paramField.get(param) == null || override) {
                paramField.set(param, value);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFieldException) {
                if (this.properties.isWarnWhenNoSuchField()) {
                    this.LOG.warn("Can not init default value. Becouse of: No field({}) in Bean({}).", (Object)fieldName, (Object)param.getClass().getName());
                }
            }
            this.LOG.error("Init field({}) of Bean({}) fail. Becouse of: {}", new Object[]{fieldName, param.getClass().getName(), e.getLocalizedMessage()});
        }
    }

    private Object resetInsertParameter(Object params) {
        if (params != null) {
            Date currentDate = new Date();
            String currentUser = SessionUtil.getUserCodeFromSession();
            if (StringUtils.isBlank((CharSequence)currentUser)) {
                currentUser = this.properties.getDefaultAuditorCode();
            }
            if (params instanceof MapperMethod.ParamMap) {
                Object collection;
                if (((MapperMethod.ParamMap)params).containsKey((Object)"collection") && (collection = ((MapperMethod.ParamMap)params).get((Object)"collection")) != null && collection instanceof List) {
                    ArrayList newParam = new ArrayList();
                    for (Object po : (List)collection) {
                        Class<?> clazz = po.getClass();
                        this.initParamField(po, clazz, this.properties.getVersionFieldName(), 1, this.properties.isOverrideDefaultName());
                        this.initParamField(po, clazz, this.properties.getCreateDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                        this.initParamField(po, clazz, this.properties.getCreateByFieldName(), currentUser, this.properties.isOverrideDefaultName());
                        this.initParamField(po, clazz, this.properties.getLastModifiedDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                        this.initParamField(po, clazz, this.properties.getLastModifiedByFieldName(), currentUser, this.properties.isOverrideDefaultName());
                        newParam.add(po);
                    }
                    ((MapperMethod.ParamMap)params).put((Object)"collection", newParam);
                }
            } else if (!(params instanceof MapperMethod.ParamMap)) {
                Class<?> clazz = params.getClass();
                this.initParamField(params, clazz, this.properties.getVersionFieldName(), 1, this.properties.isOverrideDefaultName());
                this.initParamField(params, clazz, this.properties.getCreateDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                this.initParamField(params, clazz, this.properties.getCreateByFieldName(), currentUser, this.properties.isOverrideDefaultName());
                this.initParamField(params, clazz, this.properties.getLastModifiedDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                this.initParamField(params, clazz, this.properties.getLastModifiedByFieldName(), currentUser, this.properties.isOverrideDefaultName());
            }
        }
        return params;
    }

    private Object resetUpdateParameter(Object params) {
        if (params != null) {
            Date currentDate = new Date();
            String currentUser = SessionUtil.getUserCodeFromSession();
            if (StringUtils.isBlank((CharSequence)currentUser)) {
                currentUser = this.properties.getDefaultAuditorCode();
            }
            if (params instanceof MapperMethod.ParamMap) {
                if (((MapperMethod.ParamMap)params).containsKey((Object)"record")) {
                    Object param = ((MapperMethod.ParamMap)params).get((Object)"record");
                    Class<?> clazz = param.getClass();
                    this.initParamField(param, clazz, this.properties.getLastModifiedDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                    this.initParamField(param, clazz, this.properties.getLastModifiedByFieldName(), currentUser, this.properties.isOverrideDefaultName());
                    ((MapperMethod.ParamMap)params).put((Object)"record", param);
                }
            } else {
                Class<?> clazz = params.getClass();
                this.initParamField(params, clazz, this.properties.getLastModifiedDateFieldName(), currentDate, this.properties.isOverrideDefaultTime());
                this.initParamField(params, clazz, this.properties.getLastModifiedByFieldName(), currentUser, this.properties.isOverrideDefaultName());
            }
        }
        return params;
    }

    public Object plugin(Object target) {
        if (Executor.class.isAssignableFrom(target.getClass())) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
    }

    public int getOrder() {
        return 20000;
    }
}

