/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.plugin;

import brave.ScopedSpan;
import brave.Tracing;
import com.alibaba.fastjson.JSONObject;
import com.cntaiping.fsc.common.util.Commons;
import com.cntaiping.fsc.core.model.Page;
import com.cntaiping.fsc.core.model.Pageable;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.mybatis.base.DataPrivilege;
import com.cntaiping.fsc.mybatis.cache.SimpleCache;
import com.cntaiping.fsc.mybatis.dialect.AbstractDialect;
import com.cntaiping.fsc.mybatis.plugin.BaseMybatisInterceptor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.NotExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.ParenthesedFromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.springframework.core.Ordered;
import org.springframework.data.domain.Sort;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MybatisPageableInterceptor
extends BaseMybatisInterceptor
implements Ordered {
    public static final String SUB_SQL = "SUB_SQL";
    public static final int ORDER = 10000;
    private AbstractDialect dialect;
    private RedisTemplate<String, Object> jsonRedisTemplate;
    private PathMatcher urlMatcher;
    private PathMatcher daoMatcher;
    private final SimpleCache<String, MappedStatement> countMappedStatementCache = new SimpleCache(128);

    public MybatisPageableInterceptor() {
        this.urlMatcher = new AntPathMatcher();
        this.daoMatcher = new AntPathMatcher();
    }

    private String initSQL(String sql) {
        sql = sql.replaceAll(";$", "").replaceAll("\\s(?i)where\\s", " WHERE ").replaceAll("\\s(?i)from\\s", " FROM ").replaceAll("\\s(?i)join\\s", " JOIN ").replaceAll("\\s(?i)order\\s(?i)by\\s", " ORDER BY ");
        return sql;
    }

    public Object intercept(Invocation inv) throws Throwable {
        ArrayList<Page> result;
        Object[] queryArgs = inv.getArgs();
        Executor executor = (Executor)inv.getTarget();
        MappedStatement ms = (MappedStatement)queryArgs[MAPPED_STATEMENT_INDEX];
        String msId = ms.getId();
        String shortName = msId.substring(msId.lastIndexOf("dao.") + "dao.".length());
        this.LOG.debug("SQL type:{}, msId: {}", (Object)ms.getSqlCommandType(), (Object)msId);
        Pageable pageRequest = MybatisPageableInterceptor.findPageableObject(queryArgs[PARAMETER_INDEX]);
        if (pageRequest == null) {
            Sort sortParma = MybatisPageableInterceptor.findSortObject(queryArgs[PARAMETER_INDEX]);
            if (sortParma != null) {
                queryArgs[MybatisPageableInterceptor.PARAMETER_INDEX] = MybatisPageableInterceptor.findParameterObject(queryArgs[PARAMETER_INDEX]);
            }
            BoundSql boundSql = ms.getBoundSql(queryArgs[PARAMETER_INDEX]);
            String sql = this.getDataFilterSQL(this.initSQL(this.removeBreakingWhitespace(boundSql.getSql().trim())), msId, shortName);
            if (sortParma != null) {
                sql = this.dialect.getSortString(sql, sortParma);
            }
            if ((msId.endsWith("findAll") || msId.endsWith("findList") || msId.endsWith("findListByMap")) && this.properties.getMaxFetchSize() > 0) {
                this.LOG.debug("Auto set max fetch size into SQL, fetch size is: {}", (Object)this.properties.getMaxFetchSize());
                sql = this.dialect.getLimitString(sql, 0, this.properties.getMaxFetchSize());
            }
            queryArgs[MybatisPageableInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(ms, boundSql, sql);
            result = this.proceed(inv, queryArgs);
        } else {
            Object originalParameter = queryArgs[PARAMETER_INDEX];
            queryArgs[MybatisPageableInterceptor.PARAMETER_INDEX] = MybatisPageableInterceptor.findParameterObject(originalParameter);
            BoundSql boundSql = ms.getBoundSql(queryArgs[PARAMETER_INDEX]);
            String sql = this.getDataFilterSQL(this.initSQL(this.removeBreakingWhitespace(boundSql.getSql().trim())), msId, shortName);
            long total = this.queryTotal(executor, sql, ms, boundSql, shortName);
            sql = this.dialect.getLimitStringWithSort(sql, pageRequest.getOffset(), pageRequest.getPageSize(), pageRequest.getSort());
            queryArgs[MybatisPageableInterceptor.ROWBOUNDS_INDEX] = new RowBounds(0, Integer.MAX_VALUE);
            queryArgs[MybatisPageableInterceptor.MAPPED_STATEMENT_INDEX] = this.copyFromNewSql(ms, boundSql, sql);
            Object ret = this.proceed(inv, queryArgs);
            Page pi = new Page((List)ret, pageRequest, total);
            ArrayList<Page> tmp = new ArrayList<Page>();
            tmp.add(pi);
            result = tmp;
        }
        return result;
    }

    private Object proceed(Invocation inv, Object[] args) throws InvocationTargetException, IllegalAccessException {
        return inv.getMethod().invoke(inv.getTarget(), args);
    }

    public static Pageable findPageableObject(Object params) {
        if (params == null) {
            return null;
        }
        if (Pageable.class.isAssignableFrom(params.getClass())) {
            return (Pageable)params;
        }
        if (params instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)params;
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (paramValue == null || !Pageable.class.isAssignableFrom(paramValue.getClass())) continue;
                return (Pageable)paramValue;
            }
        }
        return null;
    }

    public static Sort findSortObject(Object params) {
        if (params == null) {
            return null;
        }
        if (Sort.class.isAssignableFrom(params.getClass())) {
            return (Sort)params;
        }
        if (params instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)params;
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (paramValue == null || !Sort.class.isAssignableFrom(paramValue.getClass())) continue;
                return (Sort)paramValue;
            }
        }
        return null;
    }

    public static Object findParameterObject(Object params) {
        MapperMethod.ParamMap paramMap;
        if (params instanceof MapperMethod.ParamMap && (paramMap = (MapperMethod.ParamMap)params).size() == 4) {
            for (Map.Entry entry : paramMap.entrySet()) {
                Object paramValue = entry.getValue();
                if (!Sort.class.isAssignableFrom(paramValue.getClass()) && !Pageable.class.isAssignableFrom(paramValue.getClass())) continue;
                return paramMap.get((Object)"param1");
            }
        }
        return params;
    }

    private MapperMethod.ParamMap<Object> addFilterParamToParamMap(MapperMethod.ParamMap<Object> paramMap, Map<String, Object> filterParam) {
        paramMap.put((Object)"filterParam", filterParam);
        return paramMap;
    }

    private Object findParameterObject(Object params, Map<String, Object> filterParam) {
        if (params != null && params instanceof MapperMethod.ParamMap) {
            MapperMethod.ParamMap paramMap = (MapperMethod.ParamMap)params;
            if (paramMap.size() == 4) {
                Object param1 = paramMap.get((Object)"param1");
                JSONObject jo = (JSONObject)JSONObject.toJSON((Object)param1);
                jo.put("filterParam", filterParam);
                return jo;
            }
            return this.addFilterParamToParamMap((MapperMethod.ParamMap<Object>)paramMap, filterParam);
        }
        return this.addFilterParamToParamMap((MapperMethod.ParamMap<Object>)new MapperMethod.ParamMap(), filterParam);
    }

    public Object plugin(Object target) {
        if (Executor.class.isAssignableFrom(target.getClass())) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties p) {
        String dialectClass = p.getProperty("dialectClass");
        try {
            this.setDialect((AbstractDialect)Class.forName(dialectClass).getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            throw new RuntimeException("cannot create dialect instance by dialectClass:" + dialectClass, e);
        }
    }

    private long queryTotal(Executor executor, String sql, MappedStatement mappedStatement, BoundSql boundSql, String shortName) throws SQLException {
        CacheKey countCacheKey;
        ScopedSpan span = Tracing.currentTracer().startScopedSpan(shortName + ".count");
        span.tag("daoMethod", mappedStatement.getId() + ".count");
        long totalCount = 0L;
        boolean useCache = mappedStatement.getCache() != null;
        Object cacheResult = null;
        if (useCache) {
            countCacheKey = this.createCountResultCacheKey(mappedStatement, boundSql);
            cacheResult = mappedStatement.getCache().getObject((Object)countCacheKey);
        }
        String countSql = null;
        if (cacheResult != null) {
            span.tag("UseCountCache", "true");
            totalCount = (Long)cacheResult;
        } else {
            try {
                Object o;
                MappedStatement countMappedStatement = this.createCountMappedStatement(mappedStatement);
                countSql = this.dialect.getCountString(sql);
                Object parameterObject = boundSql.getParameterObject();
                BoundSql countBoundSql = new BoundSql(countMappedStatement.getConfiguration(), countSql, boundSql.getParameterMappings(), parameterObject);
                boundSql.getAdditionalParameters().forEach((arg_0, arg_1) -> ((BoundSql)countBoundSql).setAdditionalParameter(arg_0, arg_1));
                span.tag("UseCountCache", "false");
                span.tag("CountSql", countSql);
                countCacheKey = executor.createCacheKey(countMappedStatement, parameterObject, RowBounds.DEFAULT, countBoundSql);
                List result = executor.query(countMappedStatement, parameterObject, RowBounds.DEFAULT, null, countCacheKey, countBoundSql);
                if (result != null && !result.isEmpty() && (o = result.get(0)) != null) {
                    totalCount = Long.parseLong(o.toString());
                }
                if (useCache) {
                    mappedStatement.getCache().putObject((Object)countCacheKey, (Object)totalCount);
                }
            }
            catch (SQLException e) {
                this.LOG.error("\u67e5\u8be2\u603b\u8bb0\u5f55\u6570\u51fa\u9519\uff0c\u539f\u56e0: {}. \u9519\u8bef\u7684SQL\uff1a{}", (Object)e.getLocalizedMessage(), (Object)countSql);
                throw e;
            }
        }
        span.finish();
        return totalCount;
    }

    private MappedStatement createCountMappedStatement(MappedStatement ms) {
        String countId = ms.getId() + "_tp_auto_count";
        Configuration configuration = ms.getConfiguration();
        return this.countMappedStatementCache.computeIfAbsent(countId, key -> {
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, key, ms.getSqlSource(), ms.getSqlCommandType());
            builder.resource(ms.getResource());
            builder.fetchSize(ms.getFetchSize());
            builder.statementType(ms.getStatementType());
            builder.timeout(ms.getTimeout());
            builder.parameterMap(ms.getParameterMap());
            ResultMap resultMap = new ResultMap.Builder(configuration, countId + "_rm", Long.class, Collections.emptyList()).build();
            builder.resultMaps(Collections.singletonList(resultMap));
            builder.resultSetType(ms.getResultSetType());
            builder.cache(ms.getCache());
            builder.flushCacheRequired(ms.isFlushCacheRequired());
            builder.useCache(ms.isUseCache());
            return builder.build();
        });
    }

    private void setParameters(PreparedStatement ps, MappedStatement mappedStatement, BoundSql boundSql, Object parameterObject) throws SQLException {
        DefaultParameterHandler parameterHandler = new DefaultParameterHandler(mappedStatement, parameterObject, boundSql);
        parameterHandler.setParameters(ps);
    }

    public AbstractDialect getDialect() {
        return this.dialect;
    }

    public void setDialect(AbstractDialect dialect) {
        this.dialect = dialect;
    }

    private MappedStatement copyFromNewSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = this.copyFromBoundSql(ms, boundSql, sql);
        return this.copyFromMappedStatement(ms, new BoundSqlSqlSource(newBoundSql));
    }

    public int getOrder() {
        return 10000;
    }

    private BoundSql copyFromBoundSql(MappedStatement ms, BoundSql boundSql, String sql) {
        BoundSql newBoundSql = new BoundSql(ms.getConfiguration(), sql, boundSql.getParameterMappings(), boundSql.getParameterObject());
        for (ParameterMapping mapping : boundSql.getParameterMappings()) {
            String prop = mapping.getProperty();
            if (!boundSql.hasAdditionalParameter(prop)) continue;
            newBoundSql.setAdditionalParameter(prop, boundSql.getAdditionalParameter(prop));
        }
        return newBoundSql;
    }

    private MappedStatement copyFromMappedStatement(MappedStatement ms, SqlSource newSqlSource) {
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), ms.getId(), newSqlSource, ms.getSqlCommandType());
        builder.resource(ms.getResource());
        builder.fetchSize(ms.getFetchSize());
        builder.statementType(ms.getStatementType());
        builder.keyGenerator(ms.getKeyGenerator());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            StringBuffer keyProperties = new StringBuffer();
            for (String keyProperty : ms.getKeyProperties()) {
                keyProperties.append(keyProperty).append(",");
            }
            keyProperties.delete(keyProperties.length() - 1, keyProperties.length());
            builder.keyProperty(keyProperties.toString());
        }
        builder.timeout(ms.getTimeout());
        builder.parameterMap(ms.getParameterMap());
        builder.resultMaps(ms.getResultMaps());
        builder.resultSetType(ms.getResultSetType());
        builder.cache(ms.getCache());
        builder.flushCacheRequired(ms.isFlushCacheRequired());
        builder.useCache(ms.isUseCache());
        return builder.build();
    }

    private String getDataFilterSQL(String sql, String msId, String daoMethod) throws SQLException {
        if (!this.properties.isEnableDataPrivilege()) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: DataPrivilege is disable, skip getDataFilterSQL.");
            return sql;
        }
        if (!this.isLimitedDaoMethod(msId)) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: Is not Limited DaoMethod, skip getDataFilterSQL.");
            return sql;
        }
        Object dataPrivilege = null;
        HttpServletRequest request = SessionUtil.getHttpRequest();
        if (request == null) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: no httpServletRequest in current thread, skip getDataFilterSQL.");
            return sql;
        }
        String userCode = SessionUtil.getUserCodeFromSession((HttpSession)request.getSession());
        if (StringUtils.isBlank((CharSequence)userCode)) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: no userCode in current requset, skip getDataFilterSQL.");
            return sql;
        }
        String servletPath = request.getServletPath();
        if (this.properties.getExcludedUrls() != null && !this.properties.getExcludedUrls().isEmpty() && this.isExcludedUrl(servletPath)) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: excludedUrls contain url(" + servletPath + "), skip getDataFilterSQL.");
            return sql;
        }
        if (this.properties.getLimitedUrls() != null) {
            if (this.properties.getLimitedUrls().isEmpty()) {
                this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: limitedUrls is empty url, skip getDataFilterSQL.");
                return sql;
            }
            if (!this.isLimitedUrl(servletPath)) {
                this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: limitedUrls does not contain url(" + servletPath + "), skip getDataFilterSQL.");
                return sql;
            }
        }
        if (this.properties.getLimitedTables() == null || this.properties.getLimitedTables().isEmpty()) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: no limitedTables in app common config, skip getDataFilterSQL.");
            return sql;
        }
        try {
            return this.processSql(sql, msId);
        }
        catch (JSQLParserException e) {
            this.LOG.warn(e.getMessage(), (Throwable)e);
            return sql;
        }
    }

    private String processSql(String sql, String msId) throws JSQLParserException {
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        if (statement instanceof Select) {
            Select select = (Select)statement;
            this.processSelectBody((Statement)select, msId);
            List withItemsList = select.getWithItemsList();
            if (!Commons.isEmpty((Object)withItemsList)) {
                withItemsList.forEach(withItem -> this.processSelectBody((Statement)withItem, msId));
            }
        }
        sql = statement.toString();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("parse the finished SQL: " + sql);
        }
        return sql;
    }

    protected void processSelectBody(Statement selectBody, String msId) {
        SetOperationList operationList;
        List selects;
        if (selectBody == null) {
            return;
        }
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            this.processPlainSelect(plainSelect, msId);
        } else if (selectBody instanceof ParenthesedSelect) {
            ParenthesedSelect parenthesedSelect = (ParenthesedSelect)selectBody;
            this.processSelectBody((Statement)parenthesedSelect.getSelect(), msId);
        } else if (selectBody instanceof SetOperationList && Commons.isNotEmpty((Object)(selects = (operationList = (SetOperationList)selectBody).getSelects()))) {
            selects.forEach(body -> this.processSelectBody((Statement)body, msId));
        }
    }

    protected void processPlainSelect(PlainSelect plainSelect, String msId) {
        List selectItems = plainSelect.getSelectItems();
        if (Commons.isNotEmpty((Object)selectItems)) {
            selectItems.forEach(selectItem -> this.processSelectItem((SelectItem)selectItem, msId));
        }
        Expression where = plainSelect.getWhere();
        this.processWhereSubSelect(where, msId);
        FromItem fromItem = plainSelect.getFromItem();
        List<Table> list = this.processFromItem(fromItem, msId);
        List<Table> mainTables = new ArrayList<Table>(list);
        List joins = plainSelect.getJoins();
        if (Commons.isNotEmpty((Object)joins)) {
            mainTables = this.processJoins(mainTables, joins, msId);
        }
        if (Commons.isNotEmpty(mainTables)) {
            plainSelect.setWhere(this.builderExpression(where, mainTables, msId));
        }
    }

    private List<Table> processFromItem(FromItem fromItem, String msId) {
        ArrayList<Table> mainTables = new ArrayList<Table>();
        if (fromItem instanceof Table) {
            Table fromTable = (Table)fromItem;
            mainTables.add(fromTable);
        } else if (fromItem instanceof ParenthesedFromItem) {
            List<Table> tables = this.processSubJoin((ParenthesedFromItem)fromItem, msId);
            mainTables.addAll(tables);
        } else {
            this.processOtherFromItem(fromItem, msId);
        }
        return mainTables;
    }

    protected void processWhereSubSelect(Expression where, String msId) {
        if (where == null) {
            return;
        }
        if (where instanceof FromItem) {
            this.processOtherFromItem((FromItem)where, msId);
            return;
        }
        if (where.toString().indexOf("SELECT") > 0) {
            if (where instanceof BinaryExpression) {
                BinaryExpression expression = (BinaryExpression)where;
                this.processWhereSubSelect(expression.getLeftExpression(), msId);
                this.processWhereSubSelect(expression.getRightExpression(), msId);
            } else if (where instanceof InExpression) {
                InExpression expression = (InExpression)where;
                Expression inExpression = expression.getRightExpression();
                if (inExpression instanceof Select) {
                    this.processSelectBody((Statement)((Select)inExpression), msId);
                }
            } else if (where instanceof ExistsExpression) {
                ExistsExpression expression = (ExistsExpression)where;
                this.processWhereSubSelect(expression.getRightExpression(), msId);
            } else if (where instanceof NotExpression) {
                NotExpression expression = (NotExpression)where;
                this.processWhereSubSelect(expression.getExpression(), msId);
            } else if (where instanceof Parenthesis) {
                Parenthesis expression = (Parenthesis)where;
                this.processWhereSubSelect(expression.getExpression(), msId);
            }
        }
    }

    protected void processSelectItem(SelectItem selectItem, String msId) {
        Expression expression = selectItem.getExpression();
        if (expression instanceof Select) {
            this.processSelectBody((Statement)((Select)expression), msId);
        } else if (expression instanceof Function) {
            this.processFunction((Function)expression, msId);
        } else if (expression instanceof ExistsExpression) {
            ExistsExpression existsExpression = (ExistsExpression)expression;
            this.processSelectBody((Statement)((Select)existsExpression.getRightExpression()), msId);
        }
    }

    protected void processFunction(Function function, String msId) {
        ExpressionList parameters = function.getParameters();
        if (parameters != null) {
            parameters.forEach(expression -> {
                if (expression instanceof Select) {
                    this.processSelectBody((Statement)((Select)expression), msId);
                } else if (expression instanceof Function) {
                    this.processFunction((Function)expression, msId);
                } else if (expression instanceof EqualsTo) {
                    if (((EqualsTo)expression).getLeftExpression() instanceof Select) {
                        this.processSelectBody((Statement)((Select)((EqualsTo)expression).getLeftExpression()), msId);
                    }
                    if (((EqualsTo)expression).getRightExpression() instanceof Select) {
                        this.processSelectBody((Statement)((Select)((EqualsTo)expression).getRightExpression()), msId);
                    }
                }
            });
        }
    }

    protected void processOtherFromItem(FromItem fromItem, String msId) {
        if (fromItem instanceof ParenthesedSelect) {
            Select subSelect = (Select)fromItem;
            this.processSelectBody((Statement)subSelect, msId);
        } else if (fromItem instanceof ParenthesedFromItem) {
            this.LOG.debug("Perform a subQuery, if you do not give us feedback");
        }
    }

    private List<Table> processSubJoin(ParenthesedFromItem subJoin, String whereSegment) {
        ArrayList<Table> mainTables = new ArrayList<Table>();
        while (subJoin.getJoins() == null && subJoin.getFromItem() instanceof ParenthesedFromItem) {
            subJoin = (ParenthesedFromItem)subJoin.getFromItem();
        }
        if (subJoin.getJoins() != null) {
            List<Table> list = this.processFromItem(subJoin.getFromItem(), whereSegment);
            mainTables.addAll(list);
            this.processJoins(mainTables, subJoin.getJoins(), whereSegment);
        }
        return mainTables;
    }

    private List<Table> processJoins(List<Table> mainTables, List<Join> joins, String msId) {
        Table mainTable = null;
        Table leftTable = null;
        if (mainTables.size() == 1) {
            leftTable = mainTable = mainTables.get(0);
        }
        LinkedList<List<Table>> onTableDeque = new LinkedList<List<Table>>();
        for (Join join : joins) {
            FromItem joinItem = join.getRightItem();
            List<Object> joinTables = null;
            if (joinItem instanceof Table) {
                joinTables = new ArrayList<Table>();
                joinTables.add((Table)joinItem);
            } else if (joinItem instanceof ParenthesedFromItem) {
                joinTables = this.processSubJoin((ParenthesedFromItem)joinItem, msId);
            }
            if (joinTables != null) {
                LinkedList<Expression> onExpressions;
                Collection originOnExpressions;
                if (join.isSimple()) {
                    mainTables.addAll(joinTables);
                    continue;
                }
                Table joinTable = (Table)joinTables.get(0);
                List<Table> onTables = null;
                if (join.isRight()) {
                    mainTable = joinTable;
                    mainTables.clear();
                    if (leftTable != null) {
                        onTables = Collections.singletonList(leftTable);
                    }
                } else if (join.isInner()) {
                    onTables = mainTable == null ? Collections.singletonList(joinTable) : Arrays.asList(mainTable, joinTable);
                    mainTable = null;
                    mainTables.clear();
                } else {
                    onTables = Collections.singletonList(joinTable);
                }
                if (mainTable != null && !mainTables.contains(mainTable)) {
                    mainTables.add(mainTable);
                }
                if ((originOnExpressions = join.getOnExpressions()).size() == 1 && onTables != null) {
                    onExpressions = new LinkedList<Expression>();
                    onExpressions.add(this.builderExpression((Expression)originOnExpressions.iterator().next(), onTables, msId));
                    join.setOnExpressions(onExpressions);
                    leftTable = mainTable == null ? joinTable : mainTable;
                    continue;
                }
                onTableDeque.push(onTables);
                if (originOnExpressions.size() > 1) {
                    onExpressions = new LinkedList();
                    for (Expression originOnExpression : originOnExpressions) {
                        List currentTableList = (List)onTableDeque.poll();
                        if (Commons.isEmpty((Object)currentTableList)) {
                            onExpressions.add(originOnExpression);
                            continue;
                        }
                        onExpressions.add(this.builderExpression(originOnExpression, currentTableList, msId));
                    }
                    join.setOnExpressions(onExpressions);
                }
                leftTable = joinTable;
                continue;
            }
            this.processOtherFromItem(joinItem, msId);
            leftTable = null;
        }
        return mainTables;
    }

    protected Expression builderExpression(Expression currentExpression, List<Table> tables, String msId) {
        if (Commons.isEmpty(tables)) {
            return currentExpression;
        }
        List expressions = tables.stream().map(item -> this.buildTableExpression((Table)item, currentExpression, msId)).filter(Objects::nonNull).collect(Collectors.toList());
        if (Commons.isEmpty(expressions)) {
            return currentExpression;
        }
        Expression injectExpression = (Expression)expressions.get(0);
        if (expressions.size() > 1) {
            for (int i = 1; i < expressions.size(); ++i) {
                injectExpression = new AndExpression(injectExpression, (Expression)expressions.get(i));
            }
        }
        if (currentExpression == null) {
            return injectExpression;
        }
        if (currentExpression instanceof OrExpression) {
            return new AndExpression((Expression)new Parenthesis(currentExpression), injectExpression);
        }
        return new AndExpression(currentExpression, injectExpression);
    }

    public Expression buildTableExpression(Table table, Expression where, String msId) {
        String tableName;
        String userCode = SessionUtil.getUserCodeFromSession();
        String servletPath = SessionUtil.getHttpRequest().getServletPath();
        if (Commons.isEmpty((Object)userCode)) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: no user logged in");
        }
        if (!this.isLimitedTable(tableName = table.getName())) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL: limitedTables does not contain table(" + tableName + "), skip getDataFilterSQL.");
            return null;
        }
        DataPrivilege dataPrivilege = null;
        this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL userCode: " + userCode);
        this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL servletPath: " + servletPath);
        if (this.jsonRedisTemplate != null && StringUtils.isNotBlank((CharSequence)userCode)) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL userCode: " + userCode);
            String redisKey = "DataPrivilegeRule:" + userCode;
            if (Boolean.TRUE.equals(this.jsonRedisTemplate.hasKey((Object)redisKey))) {
                dataPrivilege = (DataPrivilege)this.jsonRedisTemplate.opsForHash().get((Object)redisKey, (Object)tableName.toLowerCase());
            } else {
                this.LOG.debug("WARNING userCode[{}] has no data privilege! \u8be5\u7528\u6237\u6ca1\u6709\u4efb\u4f55\u6570\u636e\u6743\u9650\u63a7\u5236\uff0c\u53ef\u80fd\u67e5\u8be2\u5230\u5f53\u524d\u8868[{}]\u7684\u6240\u6709\u6570\u636e\uff01", (Object)userCode, (Object)tableName);
            }
        } else {
            this.LOG.warn("MybatisPageableInterceptor failure! JsonRedisTemplate is null! ");
        }
        if (dataPrivilege == null) {
            this.LOG.debug("MybatisPageableInterceptor getDataFilterSQL dataPrivilege is null, skip getDataFilterSQL.");
            return null;
        }
        String alias = Optional.ofNullable(table.getAlias()).map(Alias::getName).orElse(null);
        try {
            if (Commons.isEmpty((Object)alias)) {
                String dataPrivilegeSql = dataPrivilege.getDataPrivilegeSql();
                return CCJSqlParserUtil.parseExpression((String)dataPrivilegeSql);
            }
            dataPrivilege.setTableAlias(alias);
            dataPrivilege.setDataPrivilegeSqlWithAlias(null);
            String dataPrivilegeSql = dataPrivilege.getDataPrivilegeSqlWithAlias();
            return CCJSqlParserUtil.parseExpression((String)dataPrivilegeSql);
        }
        catch (JSQLParserException e) {
            this.LOG.warn(e.getLocalizedMessage());
            return null;
        }
    }

    private boolean isExcludedUrl(String servletPath) {
        if (this.properties.getExcludedUrls() != null) {
            for (String url : this.properties.getExcludedUrls()) {
                if (!StringUtils.isNotBlank((CharSequence)url) || !this.urlMatcher.match(url, servletPath)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isLimitedUrl(String servletPath) {
        if (this.properties.getLimitedUrls() != null) {
            for (String url : this.properties.getLimitedUrls()) {
                if (!StringUtils.isNotBlank((CharSequence)url) || !this.urlMatcher.match(url, servletPath)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isLimitedTable(String tableName) {
        if (this.properties.getLimitedTables() != null) {
            for (String limitedTable : this.properties.getLimitedTables()) {
                if (!tableName.equalsIgnoreCase(limitedTable)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean isLimitedDaoMethod(String msId) {
        if (this.properties.getLimitedMappedStatementIds() != null) {
            for (String limitDaoMethod : this.properties.getLimitedMappedStatementIds()) {
                if (!StringUtils.isNotBlank((CharSequence)limitDaoMethod) || !this.daoMatcher.match(limitDaoMethod, msId)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public RedisTemplate<String, Object> getJsonRedisTemplate() {
        return this.jsonRedisTemplate;
    }

    public void setJsonRedisTemplate(RedisTemplate<String, Object> jsonRedisTemplate) {
        this.jsonRedisTemplate = jsonRedisTemplate;
    }

    public static class BoundSqlSqlSource
    implements SqlSource {
        BoundSql boundSql;

        public BoundSqlSqlSource(BoundSql boundSql) {
            this.boundSql = boundSql;
        }

        public BoundSql getBoundSql(Object parameterObject) {
            return this.boundSql;
        }
    }
}

