/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.util;

import com.alibaba.fastjson.JSON;
import com.cntaiping.fsc.core.util.SequenceUtil;
import com.cntaiping.fsc.mybatis.base.DataPrivilege;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeOperator;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeRule;
import com.cntaiping.fsc.mybatis.base.DataPrivilegeRuleValueType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.util.Assert;

public class DataPrivilegeUtil {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private JdbcTemplate jdbcTemplate;
    private RedisTemplate<String, Object> jsonRedisTemplate;

    public DataPrivilegeUtil(JdbcTemplate jdbcTemplate, RedisTemplate<String, Object> jsonRedisTemplate) {
        this.jdbcTemplate = jdbcTemplate;
        this.jsonRedisTemplate = jsonRedisTemplate;
    }

    @Async
    public void refreshDataPrivilegeToRedis(String userCode) {
        Assert.hasText((String)userCode, (String)"Usercode cannot be null!");
        if (this.jsonRedisTemplate.hasKey((Object)("DataPrivilegeRule:" + userCode)).booleanValue()) {
            this.jsonRedisTemplate.delete((Object)("DataPrivilegeRule:" + userCode));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT sff.field_code,sup.data_oper,sup.data_value,sf.data_type,sff.entity_code FROM ");
        sb.append("saa_user_power sup, saa_factor_field sff, saa_factor sf WHERE ");
        sb.append("sup.factor_code = sff.factor_code ");
        sb.append("and sff.factor_code = sf.factor_code ");
        sb.append("and sup.user_code = '" + userCode + "' ");
        sb.append("and sf.validind = '1' ");
        String getRoleSql = sb.toString();
        this.LOG.debug("DataPrivilegeUtil getRoleSql: " + getRoleSql);
        List saaConfigList = this.jdbcTemplate.queryForList(getRoleSql);
        this.LOG.debug("DataPrivilegeUtil saaConfigList: " + JSON.toJSONString((Object)saaConfigList));
        if (saaConfigList != null && !saaConfigList.isEmpty()) {
            HashMap<String, DataPrivilege> dataPrivilegeMap = new HashMap<String, DataPrivilege>();
            for (Map map : saaConfigList) {
                String tableName = (String)map.get("entity_code");
                String fieldName = (String)map.get("field_code");
                String[] values = map.get("data_value") != null ? ((String)map.get("data_value")).split(",") : null;
                DataPrivilegeOperator operator = map.get("data_oper") != null ? DataPrivilegeOperator.valueOf((String)map.get("data_oper")) : null;
                DataPrivilegeRuleValueType valueType = map.get("data_type") != null ? DataPrivilegeRuleValueType.valueOf((String)map.get("data_type")) : DataPrivilegeRuleValueType.Default;
                DataPrivilege dataPrivilege = null;
                if (dataPrivilegeMap.containsKey(tableName)) {
                    dataPrivilege = (DataPrivilege)dataPrivilegeMap.get(tableName);
                } else {
                    dataPrivilege = new DataPrivilege();
                    String dataPrivilegeId = SequenceUtil.createSeqNo((String)"DP");
                    dataPrivilege.setDataPrivilegeId(dataPrivilegeId);
                    dataPrivilege.setTableName(tableName);
                    dataPrivilege.setUserCode(userCode);
                    dataPrivilege.setConformAllRule(true);
                }
                DataPrivilegeRule dataPrivilegeRule = null;
                dataPrivilegeRule = new DataPrivilegeRule(tableName, fieldName, operator, values, valueType);
                dataPrivilege.addDataPrivilegeRules(dataPrivilegeRule);
                dataPrivilegeMap.put(tableName, dataPrivilege);
            }
            if (!dataPrivilegeMap.isEmpty()) {
                for (Map.Entry entry : dataPrivilegeMap.entrySet()) {
                    this.jsonRedisTemplate.opsForHash().put((Object)("DataPrivilegeRule:" + userCode), (Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
                }
                this.jsonRedisTemplate.expire((Object)("DataPrivilegeRule:" + userCode), 12L, TimeUnit.HOURS);
                this.LOG.debug("DataPrivilegeUtil refreshDataPrivilegeToRedis finished! DataPrivilege size: {}", (Object)dataPrivilegeMap.size());
            } else {
                this.LOG.debug("DataPrivilegeUtil refreshDataPrivilegeToRedis finished! DataPrivilege is Empty!");
            }
            dataPrivilegeMap.clear();
            dataPrivilegeMap = null;
        }
    }

    public List<DataPrivilege> getDataPrivilegeByUserCode(String userCode) {
        List result = null;
        try {
            result = this.jsonRedisTemplate.opsForHash().values((Object)("DataPrivilegeRule:" + userCode));
        }
        catch (Exception e) {
            this.LOG.error(e.getLocalizedMessage());
        }
        return result == null || result.isEmpty() ? null : result;
    }
}

