/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.mybatis.util;

import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class MybatisCacheRefreshUtil {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private RedisTemplate<String, Object> redisTemplate;

    public MybatisCacheRefreshUtil(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void refreshMybatisCache(HashSet<String> daoNames) {
        for (String daoName : daoNames) {
            this.clear(daoName);
        }
    }

    private void clear(String daoName) {
        this.LOG.debug("Clear Mybatis Cache for Dao: {}", (Object)daoName);
        this.redisTemplate.delete((Object)("MybatisCacheLru2:" + daoName));
        this.redisTemplate.delete((Object)("MybatisCache2:" + daoName));
    }
}

