/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.redis.config;

import com.cntaiping.fsc.redis.config.TpRedisConfiguration;
import com.cntaiping.fsc.redis.config.TpRedisProperties;
import com.cntaiping.fsc.redis.redis.LettuceConnectionHeartBeat;
import io.lettuce.core.ClientOptions;
import io.lettuce.core.RedisClient;
import io.lettuce.core.SocketOptions;
import java.time.Duration;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.data.redis.LettuceClientConfigurationBuilderCustomizer;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;

@Configuration
@AutoConfiguration(before={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class, TpRedisConfiguration.class})
@EnableConfigurationProperties(value={TpRedisProperties.class})
@ConditionalOnClass(value={RedisClient.class, LettuceConnectionFactory.class})
public class TpLettuceConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TpLettuceConfiguration.class);
    private final TpRedisProperties tpRedisProperties;
    private final RedisProperties properties;

    public TpLettuceConfiguration(TpRedisProperties tpRedisProperties, RedisProperties properties) {
        this.tpRedisProperties = tpRedisProperties;
        this.properties = properties;
    }

    @Bean
    public BeanPostProcessor lettuceConnectionFactoryProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof LettuceConnectionFactory) {
                    LettuceConnectionFactory lettuceConnectionFactory = (LettuceConnectionFactory)bean;
                    boolean validateConnection = TpLettuceConfiguration.this.tpRedisProperties.isValidateConnection();
                    LOGGER.info("TpLettuceConfiguration validateConnection = {}", (Object)validateConnection);
                    lettuceConnectionFactory.setValidateConnection(validateConnection);
                }
                return bean;
            }
        };
    }

    @Bean
    public LettuceConnectionHeartBeat lettuceConnectionHeartBeat(Optional<LettuceConnectionFactory> provider) {
        return provider.map(factory -> new LettuceConnectionHeartBeat((LettuceConnectionFactory)factory, this.tpRedisProperties)).orElse(null);
    }

    @Bean
    public LettuceClientConfigurationBuilderCustomizer lettuceClientConfigurationBuilderCustomizer() {
        return clientConfigurationBuilder -> {
            ConfigurablePropertyAccessor beanWrapper = PropertyAccessorFactory.forDirectFieldAccess((Object)clientConfigurationBuilder);
            ClientOptions preDefined = (ClientOptions)beanWrapper.getPropertyValue("clientOptions");
            if (preDefined != null) {
                SocketOptions socketOptions = this.getSocketOptions();
                ClientOptions newClientOptions = ClientOptions.builder().autoReconnect(preDefined.isAutoReconnect()).decodeBufferPolicy(preDefined.getDecodeBufferPolicy()).disconnectedBehavior(preDefined.getDisconnectedBehavior()).pingBeforeActivateConnection(preDefined.isPingBeforeActivateConnection()).protocolVersion(preDefined.getProtocolVersion()).publishOnScheduler(preDefined.isPublishOnScheduler()).readOnlyCommands(preDefined.getReadOnlyCommands()).requestQueueSize(preDefined.getRequestQueueSize()).scriptCharset(preDefined.getScriptCharset()).sslOptions(preDefined.getSslOptions()).suspendReconnectOnProtocolFailure(preDefined.isSuspendReconnectOnProtocolFailure()).timeoutOptions(preDefined.getTimeoutOptions()).socketOptions(socketOptions).build();
                clientConfigurationBuilder.clientOptions(newClientOptions);
            }
        };
    }

    private SocketOptions getSocketOptions() {
        Duration connectTimeout = this.properties.getConnectTimeout();
        SocketOptions.Builder builder = SocketOptions.builder();
        if (connectTimeout != null) {
            builder.connectTimeout(connectTimeout);
        }
        TpRedisProperties.UserTimeout userTimeoutProperties = this.tpRedisProperties.getUserTimeout();
        TpRedisProperties.KeepAlive keepAliveConfig = this.tpRedisProperties.getKeepAlive();
        if (keepAliveConfig.isEnabled()) {
            builder.keepAlive(SocketOptions.KeepAliveOptions.builder().enable().count(keepAliveConfig.getKeepAliveCount()).idle(keepAliveConfig.getKeepAliveIdle()).interval(keepAliveConfig.getKeepAliveInterval()).build());
        }
        if (userTimeoutProperties.isEnabled()) {
            builder.tcpUserTimeout(SocketOptions.TcpUserTimeoutOptions.builder().enable().tcpUserTimeout(userTimeoutProperties.getUserTimeout()).build());
        }
        return builder.build();
    }
}

