/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.redis.config;

import com.cntaiping.fsc.core.serializer.KryoRedisSerializer;
import com.cntaiping.fsc.core.serializer.TpRedisSerializer;
import com.esotericsoftware.kryo.Kryo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.autoconfigure.data.redis.RedisReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.connection.ReactiveRedisConnectionFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.ReactiveRedisTemplate;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@AutoConfiguration(before={RedisAutoConfiguration.class, RedisReactiveAutoConfiguration.class})
@EnableScheduling
public class TpRedisConfiguration {
    protected static final Logger LOG = LoggerFactory.getLogger(TpRedisConfiguration.class);

    public TpRedisConfiguration() {
        LOG.info("Init TpRedisConfig.");
    }

    @Bean(name={"springSessionDefaultRedisSerializer", "kryoRedisSerializer"})
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={Kryo.class})
    public KryoRedisSerializer kryoRedisSerializer() {
        LOG.info("Init KryoRedisSerializer");
        return new KryoRedisSerializer();
    }

    @Primary
    @Bean(name={"redisTemplate", "jsonRedisTemplate"})
    @ConditionalOnClass(value={RedisConnectionFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public RedisTemplate<String, Object> jsonRedisTemplate(RedisConnectionFactory connectionFactory, TpRedisSerializer<Object> tpRedisSerializer) {
        RedisTemplate redisTemplate = new RedisTemplate();
        redisTemplate.setKeySerializer(RedisSerializer.string());
        redisTemplate.setHashKeySerializer(RedisSerializer.string());
        redisTemplate.setDefaultSerializer(tpRedisSerializer);
        redisTemplate.setConnectionFactory(connectionFactory);
        LOG.info("Init TpSessionConfig jsonRedisTemplate.");
        return redisTemplate;
    }

    @Primary
    @Bean(name={"reactiveRedisTemplate"})
    @ConditionalOnClass(value={ReactiveRedisConnectionFactory.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public ReactiveRedisTemplate<String, Object> reactiveJsonRedisTemplate(ReactiveRedisConnectionFactory reactiveRedisConnectionFactory, TpRedisSerializer<Object> tpRedisSerializer) {
        LOG.info("Init TpSessionConfig reactiveRedisTemplate.");
        RedisSerializationContext serializationContext = RedisSerializationContext.newSerializationContext().key(RedisSerializer.string()).value(tpRedisSerializer).hashKey(RedisSerializer.string()).hashValue(tpRedisSerializer).build();
        return new ReactiveRedisTemplate(reactiveRedisConnectionFactory, serializationContext);
    }
}

