/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.redis.redis;

import com.cntaiping.fsc.redis.config.TpRedisProperties;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.Assert;

public class LettuceConnectionHeartBeat
implements SmartLifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(LettuceConnectionHeartBeat.class);
    public static final Duration DEFAULT_CHECK_INTERVAL = Duration.ofSeconds(30L);
    private final TpRedisProperties tpRedisProperties;
    private final LettuceConnectionFactory lettuceConnectionFactory;
    private volatile boolean running = false;
    private final ThreadPoolTaskScheduler taskScheduler;
    private ScheduledFuture<?> heartBeatFuture;

    public LettuceConnectionHeartBeat(LettuceConnectionFactory lettuceConnectionFactory, TpRedisProperties tpRedisProperties) {
        Assert.notNull((Object)lettuceConnectionFactory, (String)"tpRedisProperties can not be null");
        this.tpRedisProperties = tpRedisProperties;
        Assert.notNull((Object)lettuceConnectionFactory, (String)"lettuceConnectionFactory can not be null");
        this.lettuceConnectionFactory = lettuceConnectionFactory;
        ThreadPoolTaskScheduler taskScheduler = new ThreadPoolTaskScheduler();
        taskScheduler.setBeanName("LettuceConnectionHeartBeat");
        taskScheduler.initialize();
        this.taskScheduler = taskScheduler;
    }

    public void start() {
        if (!this.running && this.tpRedisProperties.isConnectionCheckEnabled()) {
            LOGGER.info("Start Lettuce heartBeat task scheduler.");
            Duration connectionCheckInterval = this.tpRedisProperties.getConnectionCheckInterval();
            if (connectionCheckInterval == null || connectionCheckInterval.isNegative()) {
                connectionCheckInterval = DEFAULT_CHECK_INTERVAL;
            }
            this.heartBeatFuture = this.taskScheduler.scheduleWithFixedDelay(this::validConnection, connectionCheckInterval);
            this.running = true;
        }
    }

    private void validConnection() {
        if (this.lettuceConnectionFactory != null && this.running) {
            LOGGER.debug("lettuceConnectionFactory validating.");
            try {
                this.lettuceConnectionFactory.validateConnection();
            }
            catch (Exception e) {
                LOGGER.warn("validConnection failed. {}", (Object)e.getMessage());
            }
        }
    }

    public void stop() {
        if (this.running) {
            LOGGER.info("Stop Lettuce heartBeat task scheduler.");
            this.running = false;
            if (this.taskScheduler != null) {
                this.taskScheduler.shutdown();
            }
            if (this.heartBeatFuture != null) {
                this.heartBeatFuture.cancel(true);
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }
}

