/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import java.util.Objects;
import org.springframework.boot.system.ApplicationPid;
import org.springframework.core.env.Environment;

public class AppIdGenerator {
    private final String appName;
    private final String port;

    public AppIdGenerator(Environment env) {
        Objects.requireNonNull(env, "The environment can not be empty.");
        this.appName = env.getProperty("spring.application.name", "EMPTY_APP_NAME");
        this.port = env.getProperty("server.port", "EMPTY_PORT");
    }

    public String toString() {
        String appId = System.getProperty("INSTANCE");
        if (appId != null) {
            return appId;
        }
        String pid = new ApplicationPid().toString();
        return this.appName + ":" + this.port + "_" + pid;
    }
}

