/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonHttpMessageConverter;
import com.cntaiping.fsc.security.config.FastJsonProperties;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;

@Configuration
@ConditionalOnClass(value={FastJsonHttpMessageConverter.class})
@ConditionalOnProperty(name={"spring.mvc.converters.preferred-json-mapper"}, havingValue="fastjson", matchIfMissing=false)
@EnableConfigurationProperties(value={FastJsonProperties.class})
public class FastJsonConverterConfig {
    static final String PREFERRED_MAPPER_PROPERTY = "spring.mvc.converters.preferred-json-mapper";
    private static final MediaType APPLICATION_PLUS_JSON = new MediaType("application", "*+json");
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final FastJsonProperties fastJsonProperties;

    public FastJsonConverterConfig(FastJsonProperties fastJsonProperties) {
        this.fastJsonProperties = fastJsonProperties;
    }

    @Bean
    public FastJsonHttpMessageConverter fastjsonHttpMessageConverters() {
        this.LOG.debug("Init FastJsonConverterConfig FastJsonHttpMessageConverter.");
        if (this.fastJsonProperties.getTimeZone() != null) {
            TimeZone.setDefault(this.fastJsonProperties.getTimeZone());
        }
        if (this.fastJsonProperties.getLocale() != null) {
            Locale.setDefault(this.fastJsonProperties.getLocale());
        }
        FastJsonHttpMessageConverter fastConverter = new FastJsonHttpMessageConverter();
        FastJsonConfig fastJsonConfig = new FastJsonConfig();
        fastJsonConfig.setCharset(StandardCharsets.UTF_8);
        fastJsonConfig.setDateFormat(this.fastJsonProperties.getDateFormat());
        fastConverter.setFastJsonConfig(fastJsonConfig);
        fastConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, APPLICATION_PLUS_JSON));
        return fastConverter;
    }
}

