/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.cntaiping.fsc.security.config.AppIdGenerator;
import com.cntaiping.fsc.security.config.TpSecurityProperties;
import com.cntaiping.fsc.security.filter.reactive.TpTokenGatewayPreFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;

@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class, TpSecurityProperties.class})
@ConditionalOnClass(value={EnableWebFluxSecurity.class, GlobalFilter.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class TpGatewayConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(TpGatewayConfig.class);

    private static String getAppId(Environment env) {
        return new AppIdGenerator(env).toString();
    }

    @Bean
    public TpTokenGatewayPreFilter tpTokenGatewayPreFilter(Environment env) {
        LOGGER.info("TpHttpClientConfig Init TpAppTokenInterceptor");
        String appId = TpGatewayConfig.getAppId(env);
        return new TpTokenGatewayPreFilter(appId);
    }
}

