/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.cntaiping.fsc.security.config.AppIdGenerator;
import com.cntaiping.fsc.security.config.FastJsonConverterConfig;
import com.cntaiping.fsc.security.config.TpWebClientProperties;
import com.cntaiping.fsc.security.interceptor.TpAppTokenInterceptor;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.condition.NoneNestedConditions;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.boot.web.client.RestTemplateRequestCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.env.Environment;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.web.client.RestTemplate;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={RestTemplate.class})
@AutoConfigureAfter(value={FastJsonConverterConfig.class})
@Conditional(value={NotReactiveWebApplicationCondition.class})
@EnableConfigurationProperties(value={TpWebClientProperties.class})
public class TpHttpClientConfig {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TpWebClientProperties tpWebClientProperties;

    @Bean
    public TpAppTokenInterceptor tpAppTokenInterceptor(Environment env) {
        this.LOG.info("TpHttpClientConfig Init TpAppTokenInterceptor");
        String appId = TpHttpClientConfig.getAppId(env);
        return new TpAppTokenInterceptor(appId);
    }

    private static String getAppId(Environment env) {
        return new AppIdGenerator(env).toString();
    }

    @Bean
    public RestTemplateBuilder restTemplateBuilder(ObjectProvider<HttpMessageConverters> messageConverters, ObjectProvider<RestTemplateCustomizer> restTemplateCustomizers, ObjectProvider<RestTemplateRequestCustomizer<?>> restTemplateRequestCustomizers, TpAppTokenInterceptor tpAppTokenInterceptor) {
        this.LOG.info("TpHttpClientConfig Init Tp RestTemplateBuilder");
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        HttpMessageConverters converters = (HttpMessageConverters)messageConverters.getIfUnique();
        if (converters != null) {
            builder = builder.messageConverters((Collection)converters.getConverters());
        }
        builder = this.addCustomizers(builder, restTemplateCustomizers, RestTemplateBuilder::customizers);
        builder = this.addCustomizers(builder, restTemplateRequestCustomizers, RestTemplateBuilder::requestCustomizers);
        builder = builder.additionalInterceptors(new ClientHttpRequestInterceptor[]{tpAppTokenInterceptor});
        if (this.tpWebClientProperties.getReadTimeout() != null) {
            builder = builder.setReadTimeout(this.tpWebClientProperties.getReadTimeout());
        }
        if (this.tpWebClientProperties.getConnectTimeout() != null) {
            builder = builder.setConnectTimeout(this.tpWebClientProperties.getConnectTimeout());
        }
        return builder;
    }

    private <T> RestTemplateBuilder addCustomizers(RestTemplateBuilder builder, ObjectProvider<T> objectProvider, BiFunction<RestTemplateBuilder, Collection<T>, RestTemplateBuilder> method) {
        List customizers = objectProvider.orderedStream().collect(Collectors.toList());
        if (!customizers.isEmpty()) {
            return method.apply(builder, customizers);
        }
        return builder;
    }

    static class NotReactiveWebApplicationCondition
    extends NoneNestedConditions {
        NotReactiveWebApplicationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
        private static class ReactiveWebApplication {
            private ReactiveWebApplication() {
            }
        }
    }
}

