/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.cntaiping.fsc.security.internal.TpPropertyDecrptor;
import com.cntaiping.fsc.security.internal.TpTextEncryptor;
import com.cntaiping.fsc.security.wrapper.CloudPropertyDecrptorWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.cloud.bootstrap.encrypt.KeyProperties;
import org.springframework.cloud.config.client.ConfigServicePropertySourceLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;

@Configuration
public class TpPropertySourceConfig {
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private KeyProperties key;

    public TpPropertySourceConfig() {
        this.LOG.info("Init TpPropertySourceConfig!");
    }

    @Primary
    @Bean(value={"encryptor"})
    public TextEncryptor encryptor() {
        if (StringUtils.hasText((String)this.key.getKey())) {
            this.LOG.info("Init TpPropertySourceConfig AesTextEncryptor!");
            return new TpTextEncryptor(this.key.getKey(), false);
        }
        this.LOG.info("Init TpPropertySourceConfig AesTextEncryptor with default key!");
        return new TpTextEncryptor();
    }

    @Bean(value={"tpPropertyDecrptor"})
    public TpPropertyDecrptor tpPropertyDecrptor(TextEncryptor encryptor) {
        this.LOG.info("Init TpPropertySourceConfig TpPropertyDecrptor!");
        return new TpPropertyDecrptor(encryptor);
    }

    @Configuration
    @ConditionalOnClass(value={ConfigServicePropertySourceLocator.class})
    protected static class LocalPropertyDecrptorSelector {
        protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

        protected LocalPropertyDecrptorSelector() {
        }

        @Bean(value={"CloudPropertyDecrptorWrapper"})
        @ConditionalOnBean(value={PropertySourceLocator.class})
        public CloudPropertyDecrptorWrapper cloudPropertyDecrptorWrapper(TpPropertyDecrptor tpPropertyDecrptor) {
            this.LOG.info("Init TpPropertySourceConfig CloudPropertyDecrptorWrapper!");
            return new CloudPropertyDecrptorWrapper(tpPropertyDecrptor);
        }
    }
}

