/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.cntaiping.fsc.security.config.TpSecurityProperties;
import com.cntaiping.fsc.security.filter.TpHttpBasicAuthFilter;
import com.cntaiping.fsc.security.filter.TpHttpLogoutFilter;
import com.cntaiping.fsc.security.filter.TpIpAddressFilter;
import com.cntaiping.fsc.security.filter.TpTokenAuthFilter;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.security.servlet.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.ChannelSecurityConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.HstsHeaderWriter;
import org.springframework.security.web.savedrequest.CookieRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.AnyRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;

@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class, TpSecurityProperties.class})
@ConditionalOnClass(value={EnableWebSecurity.class, AuthenticationEntryPoint.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class TpSecurityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TpSecurityConfig.class);
    protected final TpSecurityProperties tpSecurity;
    private CsrfTokenRepository csrfTokenRepository;

    public TpSecurityConfig(TpSecurityProperties tpSecurity) {
        LOG.info("Init TpSecurityConfig!");
        this.tpSecurity = tpSecurity;
    }

    @Bean
    @ConditionalOnProperty(name={"app.security.enableTpTokenAuthFilter"}, havingValue="true", matchIfMissing=true)
    public TpTokenAuthFilter tpTokenAuthFilter(@Qualifier(value="ignoredPathMatcher") PathMatcher ignoredPathMatcher) {
        LOG.info("Init TpSecurityConfig create TpHttpBasicAuthFilter!");
        TpTokenAuthFilter tpTokenAuthFilter = new TpTokenAuthFilter(this.tpSecurity);
        tpTokenAuthFilter.setMatcher(ignoredPathMatcher);
        tpTokenAuthFilter.setIgnoredUrls(this.tpSecurity.getIgnored());
        tpTokenAuthFilter.setEnableBasicAuth(this.tpSecurity.isEnableBasicAuthFilter());
        return tpTokenAuthFilter;
    }

    @Bean
    @ConditionalOnProperty(name={"app.security.enableBasicAuthFilter"}, havingValue="true", matchIfMissing=false)
    public TpHttpBasicAuthFilter tpHttpBasicAuthFilter(SecurityProperties securityProperties, @Qualifier(value="ignoredPathMatcher") PathMatcher ignoredPathMatcher, CsrfTokenRepository csrfTokenRepository) {
        LOG.info("Init TpSecurityConfig create TpHttpBasicAuthFilter!");
        SecurityProperties.User user = securityProperties.getUser();
        TpHttpBasicAuthFilter tpHttpBasicAuthFilter = new TpHttpBasicAuthFilter(user.getName(), user.getPassword());
        tpHttpBasicAuthFilter.setMatcher(ignoredPathMatcher);
        tpHttpBasicAuthFilter.setIgnoredUrls(this.tpSecurity.getIgnored());
        tpHttpBasicAuthFilter.setEnableFormLogin(this.tpSecurity.isEnableFormLogin());
        tpHttpBasicAuthFilter.setCsrfTokenRepository(csrfTokenRepository);
        return tpHttpBasicAuthFilter;
    }

    @Bean
    @ConditionalOnProperty(name={"app.security.enableHttpLogoutFilter"}, havingValue="true", matchIfMissing=true)
    public TpHttpLogoutFilter tpHttpLogoutFilter() {
        LOG.info("Init TpSecurityConfig create TpHttpLogoutFilter!");
        TpHttpLogoutFilter tpHttpLogoutFilter = new TpHttpLogoutFilter();
        return tpHttpLogoutFilter;
    }

    @Bean
    @ConditionalOnProperty(name={"app.security.enableIpAddressFilter"}, havingValue="true", matchIfMissing=true)
    public TpIpAddressFilter tpIpAddressFilter() {
        LOG.info("Init TpSecurityConfig create IpAddressFilter!");
        return new TpIpAddressFilter(this.tpSecurity.getAllowList(), this.tpSecurity.getDenyList());
    }

    @Bean
    public CsrfTokenRepository csrfTokenRepository() {
        LOG.info("Init TpSecurityConfig create CsrfTokenRepository!");
        CookieCsrfTokenRepository csrfTokenRepository = CookieCsrfTokenRepository.withHttpOnlyFalse();
        return csrfTokenRepository;
    }

    @Bean(value={"ignoredPathMatcher"})
    public PathMatcher ignoredPathMatcher() {
        LOG.info("Init TpSecurityConfig ignoredPathMatcher.");
        return new AntPathMatcher();
    }

    private HttpSecurity initHttpSecurity(HttpSecurity http) throws Exception {
        if (this.tpSecurity.isRequireSsl()) {
            http = http.requiresChannel(requiresChannel -> ((ChannelSecurityConfigurer.RequiresChannelUrl)requiresChannel.anyRequest()).requiresSecure());
        }
        http = this.tpSecurity.isEnableCsrf() ? http.csrf(csrf -> csrf.csrfTokenRepository(this.csrfTokenRepository)) : http.csrf(AbstractHttpConfigurer::disable);
        http = !this.tpSecurity.isEnableCors() ? http.cors(AbstractHttpConfigurer::disable) : http.cors(cors -> cors.configurationSource((CorsConfigurationSource)new GlobalCorsConfigurationSource(this.tpSecurity.getCors())));
        http.headers(headersConfigurer -> this.configureHeaders((HeadersConfigurer<?>)headersConfigurer, this.tpSecurity.getHeaders()));
        return http.securityMatcher((RequestMatcher)new IgnoredPathRequestMatcher(this.tpSecurity));
    }

    private void configureHeaders(HeadersConfigurer<?> headersConfigurer, TpSecurityProperties.Headers headers) {
        if (headers.getHsts() != TpSecurityProperties.Headers.HSTS.NONE) {
            boolean includeSubDomains = headers.getHsts() == TpSecurityProperties.Headers.HSTS.ALL;
            HstsHeaderWriter writer = new HstsHeaderWriter(includeSubDomains);
            writer.setRequestMatcher(AnyRequestMatcher.INSTANCE);
            headersConfigurer.addHeaderWriter((HeaderWriter)writer);
        }
        if (!headers.isContentType()) {
            headersConfigurer.contentTypeOptions(HeadersConfigurer.ContentTypeOptionsConfig::disable);
        }
        if (StringUtils.hasText((String)headers.getContentSecurityPolicy())) {
            String policyDirectives = headers.getContentSecurityPolicy();
            TpSecurityProperties.Headers.ContentSecurityPolicyMode mode = headers.getContentSecurityPolicyMode();
            if (mode == TpSecurityProperties.Headers.ContentSecurityPolicyMode.DEFAULT) {
                headersConfigurer.contentSecurityPolicy(contentSecurityPolicy -> contentSecurityPolicy.policyDirectives(policyDirectives));
            } else {
                headersConfigurer.contentSecurityPolicy(contentSecurityPolicy -> {
                    contentSecurityPolicy.policyDirectives(policyDirectives);
                    contentSecurityPolicy.reportOnly();
                });
            }
        }
        if (!headers.isXss()) {
            headersConfigurer.xssProtection(HeadersConfigurer.XXssConfig::disable);
        }
        if (!headers.isCache()) {
            headersConfigurer.cacheControl(HeadersConfigurer.CacheControlConfig::disable);
        }
        if (headers.isFrame()) {
            headersConfigurer.frameOptions(HeadersConfigurer.FrameOptionsConfig::sameOrigin);
        } else {
            headersConfigurer.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable);
        }
    }

    @Bean
    @ConditionalOnProperty(value={"app.security.basic.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0x7FFFFFFA)
    public SecurityFilterChain tpSecurityFilterChain(HttpSecurity http) throws Exception {
        return (SecurityFilterChain)this.initHttpSecurity(http).build();
    }

    @Bean
    @ConditionalOnProperty(value={"app.security.basic.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0x7FFFFFF9)
    public SecurityFilterChain actuatorSecurityFilterChain(HttpSecurity http) throws Exception {
        http.securityMatcher((RequestMatcher)EndpointRequest.toAnyEndpoint()).authorizeHttpRequests(auth -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{EndpointRequest.to((Class[])new Class[]{HealthEndpoint.class})})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)auth.requestMatchers(new RequestMatcher[]{EndpointRequest.toAnyEndpoint()})).authenticated();
        });
        http.requestCache(requestCache -> requestCache.requestCache((RequestCache)new CookieRequestCache()));
        http.httpBasic(Customizer.withDefaults());
        return (SecurityFilterChain)http.build();
    }

    private class IgnoredPathRequestMatcher
    implements RequestMatcher {
        private List<String> ignored;
        private volatile RequestMatcher delegate;

        public IgnoredPathRequestMatcher(TpSecurityProperties security) {
            this.ignored = this.getIgnored(security);
            this.initMatchers();
        }

        public boolean matches(HttpServletRequest request) {
            return !this.delegate.matches(request);
        }

        private List<String> getIgnored(TpSecurityProperties security) {
            ArrayList<String> ignored = new ArrayList<String>(security.getIgnored());
            if (ignored.isEmpty()) {
                ignored.addAll(TpSecurityProperties.DEFAULT_IGNORED);
            } else if (ignored.contains("none")) {
                ignored.remove("none");
            }
            return ignored;
        }

        private void initMatchers() {
            List matchers = this.ignored.stream().map(AntPathRequestMatcher::new).collect(Collectors.toList());
            this.delegate = new OrRequestMatcher(matchers);
        }
    }

    public static class GlobalCorsConfigurationSource
    implements CorsConfigurationSource {
        private final CorsConfiguration config;

        public GlobalCorsConfigurationSource(CorsConfiguration config) {
            this.config = config;
        }

        public CorsConfiguration getCorsConfiguration(HttpServletRequest request) {
            return this.config;
        }
    }
}

