/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.config;

import com.cntaiping.fsc.security.config.TpSecurityProperties;
import com.cntaiping.fsc.security.filter.reactive.TpServerIpAddressFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.autoconfigure.security.reactive.EndpointRequest;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.SecurityProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.web.reactive.EnableWebFluxSecurity;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.ServerAuthenticationEntryPoint;
import org.springframework.security.web.server.csrf.CookieServerCsrfTokenRepository;
import org.springframework.security.web.server.csrf.ServerCsrfTokenRepository;
import org.springframework.security.web.server.header.XFrameOptionsServerHttpHeadersWriter;
import org.springframework.security.web.server.savedrequest.CookieServerRequestCache;
import org.springframework.security.web.server.savedrequest.ServerRequestCache;
import org.springframework.security.web.server.util.matcher.OrServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.PathPatternParserServerWebExchangeMatcher;
import org.springframework.security.web.server.util.matcher.ServerWebExchangeMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Configuration
@EnableConfigurationProperties(value={SecurityProperties.class, TpSecurityProperties.class})
@ConditionalOnClass(value={EnableWebFluxSecurity.class, ServerAuthenticationEntryPoint.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
public class TpServerSecurityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(TpServerSecurityConfig.class);
    protected final TpSecurityProperties tpSecurity;

    public TpServerSecurityConfig(TpSecurityProperties tpSecurity) {
        LOG.info("Init TpServerHttpSecurity!");
        this.tpSecurity = tpSecurity;
    }

    @Bean
    @ConditionalOnProperty(name={"app.security.enableIpAddressFilter"}, havingValue="true", matchIfMissing=true)
    public TpServerIpAddressFilter tpIpAddressFilter() {
        LOG.info("Init TpServerHttpSecurity create TpServerIpAddressFilter!");
        return new TpServerIpAddressFilter(this.tpSecurity.getAllowList(), this.tpSecurity.getDenyList());
    }

    @Bean
    public ServerCsrfTokenRepository serverCsrfTokenRepository() {
        LOG.info("Init TpServerHttpSecurity create serverCsrfTokenRepository!");
        return CookieServerCsrfTokenRepository.withHttpOnlyFalse();
    }

    @Bean(value={"ignoredPathMatcher"})
    public PathMatcher ignoredPathMatcher() {
        LOG.info("Init TpServerHttpSecurity ignoredPathMatcher.");
        return new AntPathMatcher();
    }

    private ServerHttpSecurity initHttpSecurity(ServerHttpSecurity http) throws Exception {
        if (this.tpSecurity.isRequireSsl()) {
            http = http.redirectToHttps(Customizer.withDefaults());
        }
        http = this.tpSecurity.isEnableCsrf() ? http.csrf(csrf -> csrf.csrfTokenRepository(this.serverCsrfTokenRepository())) : http.csrf(ServerHttpSecurity.CsrfSpec::disable);
        if (!this.tpSecurity.isEnableCors()) {
            http = http.cors(ServerHttpSecurity.CorsSpec::disable);
        } else {
            GlobalCorsConfigurationSource corsConfigurationSource = new GlobalCorsConfigurationSource(this.tpSecurity.getCors());
            http = http.cors(cors -> cors.configurationSource((CorsConfigurationSource)corsConfigurationSource));
        }
        http = this.configureHeaders(http, this.tpSecurity.getHeaders());
        return http.securityMatcher((ServerWebExchangeMatcher)new IgnoredPathServerWebExchangeMatcher(this.tpSecurity));
    }

    private ServerHttpSecurity configureHeaders(ServerHttpSecurity http, TpSecurityProperties.Headers headers) throws Exception {
        if (headers.getHsts() != TpSecurityProperties.Headers.HSTS.NONE) {
            boolean includeSubDomains = headers.getHsts() == TpSecurityProperties.Headers.HSTS.ALL;
            http = http.headers(headerSpec -> headerSpec.hsts(hstsSpec -> hstsSpec.includeSubdomains(includeSubDomains)));
        }
        if (!headers.isContentType()) {
            http = http.headers(headerSpec -> headerSpec.contentTypeOptions(ServerHttpSecurity.HeaderSpec.ContentTypeOptionsSpec::disable));
        }
        if (StringUtils.hasText((String)headers.getContentSecurityPolicy())) {
            String policyDirectives = headers.getContentSecurityPolicy();
            TpSecurityProperties.Headers.ContentSecurityPolicyMode mode = headers.getContentSecurityPolicyMode();
            http = mode == TpSecurityProperties.Headers.ContentSecurityPolicyMode.DEFAULT ? http.headers(headerSpec -> headerSpec.contentSecurityPolicy(contentSecurityPolicySpec -> contentSecurityPolicySpec.policyDirectives(policyDirectives))) : http.headers(headerSpec -> headerSpec.contentSecurityPolicy(contentSecurityPolicySpec -> {
                contentSecurityPolicySpec.policyDirectives(policyDirectives);
                contentSecurityPolicySpec.reportOnly(true);
            }));
        }
        if (!headers.isXss()) {
            http = http.headers(headerSpec -> headerSpec.xssProtection(ServerHttpSecurity.HeaderSpec.XssProtectionSpec::disable));
        }
        if (!headers.isCache()) {
            http = http.headers(headerSpec -> headerSpec.cache(ServerHttpSecurity.HeaderSpec.CacheSpec::disable));
        }
        http = headers.isFrame() ? http.headers(headerSpec -> headerSpec.frameOptions(frameOptionsSpec -> frameOptionsSpec.mode(XFrameOptionsServerHttpHeadersWriter.Mode.SAMEORIGIN))) : http.headers(headerSpec -> headerSpec.frameOptions(ServerHttpSecurity.HeaderSpec.FrameOptionsSpec::disable));
        return http;
    }

    @Bean
    @ConditionalOnProperty(value={"app.security.basic.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0x7FFFFFFA)
    public SecurityWebFilterChain tpSecurityFilterChain(ServerHttpSecurity http) throws Exception {
        return this.initHttpSecurity(http).build();
    }

    @Bean
    @ConditionalOnProperty(value={"app.security.basic.enabled"}, havingValue="true", matchIfMissing=true)
    @Order(value=0x7FFFFFF9)
    public SecurityWebFilterChain actuatorSecurityFilterChain(ServerHttpSecurity http) throws Exception {
        http.securityMatcher((ServerWebExchangeMatcher)EndpointRequest.toAnyEndpoint()).authorizeExchange(auth -> {
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)auth.matchers(new ServerWebExchangeMatcher[]{EndpointRequest.to((Class[])new Class[]{HealthEndpoint.class})})).permitAll();
            ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)auth.matchers(new ServerWebExchangeMatcher[]{EndpointRequest.toAnyEndpoint()})).authenticated();
        });
        http.requestCache(requestCacheSpec -> requestCacheSpec.requestCache((ServerRequestCache)new CookieServerRequestCache()));
        http.httpBasic(Customizer.withDefaults());
        return http.build();
    }

    public static class GlobalCorsConfigurationSource
    implements CorsConfigurationSource {
        private final CorsConfiguration config;

        public GlobalCorsConfigurationSource(CorsConfiguration config) {
            this.config = config;
        }

        public CorsConfiguration getCorsConfiguration(ServerWebExchange exchange) {
            return this.config;
        }
    }

    public class IgnoredPathServerWebExchangeMatcher
    implements ServerWebExchangeMatcher {
        private List<String> ignored;
        private volatile ServerWebExchangeMatcher delegate;

        public IgnoredPathServerWebExchangeMatcher(TpSecurityProperties security) {
            this.ignored = this.getIgnored(security);
            this.initMatchers();
        }

        public Mono<ServerWebExchangeMatcher.MatchResult> matches(ServerWebExchange exchange) {
            return this.delegate.matches(exchange).flatMap(matchResult -> matchResult.isMatch() ? ServerWebExchangeMatcher.MatchResult.notMatch() : ServerWebExchangeMatcher.MatchResult.match());
        }

        private List<String> getIgnored(TpSecurityProperties security) {
            ArrayList<String> ignored = new ArrayList<String>(security.getIgnored());
            if (ignored.isEmpty()) {
                ignored.addAll(TpSecurityProperties.DEFAULT_IGNORED);
            } else if (ignored.contains("none")) {
                ignored.remove("none");
            }
            return ignored;
        }

        private void initMatchers() {
            List matchers = this.ignored.stream().map(PathPatternParserServerWebExchangeMatcher::new).collect(Collectors.toList());
            this.delegate = new OrServerWebExchangeMatcher(matchers);
        }
    }
}

