/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter;

import com.cntaiping.fsc.core.util.SessionUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.filter.OrderedRequestContextFilter;
import org.springframework.util.PathMatcher;

public abstract class AbstractAuthFilter
extends OrderedRequestContextFilter {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final int DEFAULT_ORDER = -125;
    protected static final String TP_AUTH_FLAG_ATTR = "TP_AUTH_FLAG_ATTR";
    protected List<String> ignoredUrls;
    protected PathMatcher matcher;

    public AbstractAuthFilter() {
        super.setOrder(-125);
    }

    public AbstractAuthFilter(int order) {
        super.setOrder(order);
    }

    public void setMatcher(PathMatcher matcher) {
        this.matcher = matcher;
    }

    public List<String> getIgnoredUrls() {
        return this.ignoredUrls;
    }

    public void setIgnoredUrls(List<String> ignoredUrls) {
        this.ignoredUrls = ignoredUrls;
    }

    protected boolean excludedUrls(HttpServletRequest request, List<String> ignoredUrls) {
        boolean excluded = false;
        String servletPath = request.getServletPath();
        for (String url : ignoredUrls) {
            if (!StringUtils.isNotEmpty((CharSequence)url) || !this.matcher.match(url, servletPath)) continue;
            excluded = true;
            break;
        }
        return excluded;
    }

    protected void clearSessionAndCookie(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        } else {
            SessionUtil.clearAllCookie((HttpServletRequest)request, (HttpServletResponse)response);
        }
    }
}

