/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter;

import com.cntaiping.fsc.core.model.BaseResponse;
import com.cntaiping.fsc.core.util.ResponseUtil;
import com.cntaiping.fsc.security.filter.AbstractAuthFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.http.HttpHeaders;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;

public class TpHttpBasicAuthFilter
extends AbstractAuthFilter {
    private static final int order = -121;
    public static final String FORM_USERNAME_KEY = "username";
    public static final String FORM_PASSWORD_KEY = "password";
    public static final String FORM_TARGETPAGE_KEY = "_targetpage";
    private String authentication;
    protected CsrfTokenRepository csrfTokenRepository;
    private boolean enableFormLogin;
    protected RequestMatcher loginRequestMatcher = new AntPathRequestMatcher("/login", "POST");

    public TpHttpBasicAuthFilter(String username, String password) {
        super(-121);
        this.authentication = "Basic " + HttpHeaders.encodeBasicAuth((String)username, (String)password, (Charset)StandardCharsets.ISO_8859_1);
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean passed = false;
        boolean needToRedirect = false;
        String targetPage = null;
        HttpSession session = null;
        Boolean hasAuthFlag = (Boolean)request.getAttribute("TP_AUTH_FLAG_ATTR");
        if (hasAuthFlag != null && hasAuthFlag.booleanValue() || this.excludedUrls(request, this.ignoredUrls)) {
            passed = true;
        } else {
            session = request.getSession(false);
            String basicAuthString = request.getHeader("Authorization");
            if (this.isAuthenticationFormRequest(request)) {
                if (session != null) {
                    session.invalidate();
                    session = null;
                }
                session = request.getSession(true);
                basicAuthString = this.fetchBaseAuthStringByFormRequest(request);
                targetPage = this.obtainTargetPage(request);
                if (StringUtils.hasText((String)targetPage)) {
                    needToRedirect = true;
                }
            }
            if (session == null) {
                passed = this.isValid(basicAuthString);
            } else {
                Boolean authFlag = (Boolean)session.getAttribute("TP_AUTH_FLAG_ATTR");
                if (authFlag != null && authFlag.booleanValue()) {
                    passed = authFlag;
                } else {
                    passed = this.isValid(basicAuthString);
                    session.setAttribute("TP_AUTH_FLAG_ATTR", (Object)passed);
                }
            }
        }
        if (passed) {
            if (this.enableFormLogin && needToRedirect && StringUtils.hasText(targetPage)) {
                response.sendRedirect(targetPage);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        } else {
            this.clearSessionAndCookie(request, response);
            if (this.enableFormLogin) {
                this.sendLoginPage(request, response);
            } else {
                BaseResponse result = new BaseResponse("0009", (Object)"Basic Auth Fail! ");
                ResponseUtil.sendErrorResponse((HttpServletRequest)request, (HttpServletResponse)response, (BaseResponse)result);
            }
        }
    }

    private boolean isValid(String basicAuthString) {
        return StringUtils.hasText((String)basicAuthString) && basicAuthString.equals(this.authentication);
    }

    private void sendLoginPage(HttpServletRequest request, HttpServletResponse response) {
        String loginHtml = this.createPage(request, response);
        response.setStatus(401);
        if (!response.isCommitted()) {
            try {
                response.getWriter().write(loginHtml);
                response.getWriter().flush();
            }
            catch (IOException e) {
                this.LOG.error("\u8fd4\u56de\u767b\u9646\u9875\u9762\u65f6\u53d1\u751fIO\u5f02\u5e38\uff1a" + e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private String createPage(HttpServletRequest request, HttpServletResponse response) {
        String page = "<!DOCTYPE html>\n<html lang=\"en\">\n  <head>\n    <meta charset=\"utf-8\">\n    <meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">\n    <meta name=\"description\" content=\"\">\n    <meta name=\"author\" content=\"Liebin Zheng\">\n    <title>Tpcloud App Login Page</title>\n    <link type=\"text/css\" href=\"/css/bootstrap.min.css\" rel=\"stylesheet\" >\n    <link type=\"text/css\" href=\"/css/signin.css\" rel=\"stylesheet\" />\n  </head>\n  <body>\n     <div class=\"container\">\n" + this.formLogin(request, response) + "    </div>\n  </body>\n</html>";
        return page;
    }

    private String formLogin(HttpServletRequest request, HttpServletResponse response) {
        String targetPageUrl;
        if (!this.enableFormLogin) {
            return "";
        }
        String contextPath = request.getContextPath();
        String loginPageUrl = contextPath + "/login";
        if (loginPageUrl.equals(targetPageUrl = request.getContextPath() + request.getRequestURI())) {
            targetPageUrl = contextPath + "/";
        }
        boolean isError = request.getParameter("error") != null;
        boolean isLogoutSuccess = request.getParameter("logout") != null;
        CsrfToken token = this.csrfTokenRepository.generateToken(request);
        return "      <form class=\"form-signin\" method=\"post\" action=\"" + loginPageUrl + "\">\n        <h2 class=\"form-signin-heading\">Please sign in</h2>\n" + this.createError(isError) + this.createLogoutSuccess(isLogoutSuccess) + "        <p>\n          <label for=\"username\" class=\"sr-only\">Username</label>\n          <input type=\"text\" id=\"username\" name=\"username\" class=\"form-control\" placeholder=\"Username\" required autofocus>\n        </p>\n        <p>\n          <label for=\"password\" class=\"sr-only\">Password</label>\n          <input type=\"password\" id=\"password\" name=\"password\" class=\"form-control\" placeholder=\"Password\" required>\n        </p>\n        <p>\n" + this.targetPage(targetPageUrl) + "        </p>\n        <p>\n" + this.csrfToken(token) + "        </p>\n        <button class=\"btn btn-lg btn-primary btn-block\" type=\"submit\">Sign in</button>\n      </form>\n";
    }

    private String csrfToken(CsrfToken token) {
        return "          <input type=\"hidden\" name=\"" + token.getParameterName() + "\" value=\"" + token.getToken() + "\">\n";
    }

    private String targetPage(String targetPageUrl) {
        return "          <input type=\"hidden\" name=\"_targetpage\" value=\"" + targetPageUrl + "\">\n";
    }

    private String createError(boolean isError) {
        return isError ? "<div class=\"alert alert-danger\" role=\"alert\">Invalid credentials</div>" : "";
    }

    private String createLogoutSuccess(boolean isLogoutSuccess) {
        return isLogoutSuccess ? "<div class=\"alert alert-success\" role=\"alert\">You have been signed out</div>" : "";
    }

    private String obtainPassword(HttpServletRequest request) {
        return request.getParameter(FORM_PASSWORD_KEY);
    }

    private String obtainUsername(HttpServletRequest request) {
        return request.getParameter(FORM_USERNAME_KEY);
    }

    private String obtainTargetPage(HttpServletRequest request) {
        return request.getParameter(FORM_TARGETPAGE_KEY);
    }

    private boolean isAuthenticationFormRequest(HttpServletRequest request) {
        return this.loginRequestMatcher.matches(request);
    }

    private String fetchBaseAuthStringByFormRequest(HttpServletRequest request) {
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        if (username == null) {
            username = "";
        }
        if (password == null) {
            password = "";
        }
        username = username.trim();
        return "Basic " + HttpHeaders.encodeBasicAuth((String)username, (String)password, (Charset)StandardCharsets.ISO_8859_1);
    }

    public void setCsrfTokenRepository(CsrfTokenRepository csrfTokenRepository) {
        this.csrfTokenRepository = csrfTokenRepository;
    }

    public void setEnableFormLogin(boolean enableFormLogin) {
        this.enableFormLogin = enableFormLogin;
    }
}

