/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter;

import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.security.filter.AbstractAuthFilter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.web.util.matcher.IpAddressMatcher;

public class TpIpAddressFilter
extends AbstractAuthFilter {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final int order = -124;
    public static final String DEFAULT_ALLOW_IPv4 = "127.0.0.1";
    public static final String DEFAULT_ALLOW_IPv6 = "0:0:0:0:0:0:0:1";
    private List<IpAddressMatcher> allowIpAddressMatchers;
    private List<IpAddressMatcher> denyIpAddressMatchers;

    public TpIpAddressFilter(List<String> allowList, List<String> denyList) {
        super(-124);
        this.initIpAddressMatchers(allowList, denyList);
    }

    private void initIpAddressMatchers(List<String> allowList, List<String> denyList) {
        if (denyList != null && !denyList.isEmpty()) {
            this.denyIpAddressMatchers = new LinkedList<IpAddressMatcher>();
            for (String ipString : denyList) {
                this.denyIpAddressMatchers.add(new IpAddressMatcher(ipString));
            }
        }
        this.allowIpAddressMatchers = new LinkedList<IpAddressMatcher>();
        this.allowIpAddressMatchers.add(new IpAddressMatcher(DEFAULT_ALLOW_IPv4));
        this.allowIpAddressMatchers.add(new IpAddressMatcher(DEFAULT_ALLOW_IPv6));
        if (allowList != null && !allowList.isEmpty()) {
            for (String ipString : allowList) {
                this.allowIpAddressMatchers.add(new IpAddressMatcher(ipString));
            }
        }
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean passed = false;
        String remoteIp = SessionUtil.getRemoteHost((HttpServletRequest)request);
        if (this.denyIpAddressMatchers != null && !this.denyIpAddressMatchers.isEmpty()) {
            for (IpAddressMatcher ipMatcher : this.denyIpAddressMatchers) {
                if (!ipMatcher.matches(remoteIp)) continue;
                throw new TpcloudException("\u9ed1\u540d\u5355IP. " + remoteIp, "0006");
            }
        }
        if (this.allowIpAddressMatchers != null && !this.allowIpAddressMatchers.isEmpty()) {
            for (IpAddressMatcher ipMatcher : this.allowIpAddressMatchers) {
                if (!ipMatcher.matches(remoteIp)) continue;
                passed = true;
                break;
            }
        }
        request.setAttribute("TP_AUTH_FLAG_ATTR", (Object)passed);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

