/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter;

import com.cntaiping.fsc.core.model.BaseResponse;
import com.cntaiping.fsc.core.util.ResponseUtil;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.security.config.TpSecurityProperties;
import com.cntaiping.fsc.security.filter.AbstractAuthFilter;
import com.cntaiping.fsc.security.util.SignatureUtil;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.TreeMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TpTokenAuthFilter
extends AbstractAuthFilter {
    private static final int order = -122;
    protected TpSecurityProperties tpSecurityProperties;
    private boolean enableBasicAuth = false;

    public TpTokenAuthFilter(TpSecurityProperties tpSecurityProperties) {
        super(-122);
        this.tpSecurityProperties = tpSecurityProperties;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        boolean passed = false;
        StringBuilder errorMsg = new StringBuilder();
        errorMsg.append("App Token validate Fail! ");
        Boolean hasAuthFlag = (Boolean)request.getAttribute("TP_AUTH_FLAG_ATTR");
        if (hasAuthFlag != null && hasAuthFlag.booleanValue() || this.excludedUrls(request, this.ignoredUrls)) {
            passed = true;
        } else {
            String requestToken = request.getHeader("x-app-token");
            if (StringUtils.hasText((String)requestToken)) {
                String appTokenInSession;
                HttpSession session = request.getSession(false);
                if (session != null && StringUtils.hasText((String)(appTokenInSession = (String)session.getAttribute("x-app-token"))) && appTokenInSession.equals(requestToken)) {
                    passed = true;
                }
                if (!passed) {
                    String appId = request.getHeader("x-app-id");
                    String random = request.getHeader("x-app-random");
                    String clientIp = request.getHeader("x-app-client-ip");
                    if (ObjectUtils.isEmpty((Object)clientIp)) {
                        clientIp = SessionUtil.getRemoteHost((HttpServletRequest)request);
                    }
                    if (StringUtils.hasText((String)appId) && StringUtils.hasText((String)random)) {
                        TreeMap<String, String> params = new TreeMap<String, String>();
                        params.put("x-app-client-ip", clientIp);
                        params.put("x-app-id", appId);
                        params.put("x-app-random", random);
                        passed = SignatureUtil.validateAppToken(requestToken, params);
                        if (!passed) {
                            errorMsg.append("Invalid App Token: ");
                            errorMsg.append(requestToken);
                        }
                    } else {
                        errorMsg.append("Miss header: ");
                        if (!StringUtils.hasText((String)appId)) {
                            errorMsg.append("x-app-id");
                        } else {
                            errorMsg.append("x-app-random");
                        }
                    }
                }
            } else {
                errorMsg.append("Miss header: ");
                errorMsg.append("x-app-token");
            }
        }
        request.setAttribute("TP_AUTH_FLAG_ATTR", (Object)passed);
        if (passed || this.enableBasicAuth) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            BaseResponse result = new BaseResponse("0009", (Object)errorMsg.toString());
            ResponseUtil.sendErrorResponse((HttpServletRequest)request, (HttpServletResponse)response, (BaseResponse)result);
        }
    }

    public void setEnableBasicAuth(boolean enableBasicAuth) {
        this.enableBasicAuth = enableBasicAuth;
    }
}

