/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter.reactive;

import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.core.util.WebSessionUtil;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.web.util.matcher.IpAddressMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class TpServerIpAddressFilter
implements WebFilter,
Ordered {
    private static final int order = -127;
    private static final Logger LOGGER = LoggerFactory.getLogger(TpServerIpAddressFilter.class);
    public static final String DEFAULT_ALLOW_IPv4 = "127.0.0.1";
    public static final String DEFAULT_ALLOW_IPv6 = "0:0:0:0:0:0:0:1";
    private List<IpAddressMatcher> allowIpAddressMatchers;
    private List<IpAddressMatcher> denyIpAddressMatchers;

    public TpServerIpAddressFilter(List<String> allowList, List<String> denyList) {
        this.initIpAddressMatchers(allowList, denyList);
    }

    public int getOrder() {
        return -127;
    }

    private void initIpAddressMatchers(List<String> allowList, List<String> denyList) {
        this.denyIpAddressMatchers = new LinkedList<IpAddressMatcher>();
        if (denyList != null && !denyList.isEmpty()) {
            for (String ipString : denyList) {
                this.denyIpAddressMatchers.add(new IpAddressMatcher(ipString));
            }
        }
        this.allowIpAddressMatchers = new LinkedList<IpAddressMatcher>();
        this.allowIpAddressMatchers.add(new IpAddressMatcher(DEFAULT_ALLOW_IPv4));
        this.allowIpAddressMatchers.add(new IpAddressMatcher(DEFAULT_ALLOW_IPv6));
        if (allowList != null && !allowList.isEmpty()) {
            for (String ipString : allowList) {
                this.allowIpAddressMatchers.add(new IpAddressMatcher(ipString));
            }
        }
    }

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        String remoteIp = WebSessionUtil.getRemoteHost((ServerHttpRequest)request);
        for (IpAddressMatcher matcher2 : this.denyIpAddressMatchers) {
            if (!matcher2.matches(remoteIp)) continue;
            return Mono.error((Throwable)new TpcloudException("\u9ed1\u540d\u5355IP. " + remoteIp, "0006"));
        }
        boolean passed = this.allowIpAddressMatchers.stream().anyMatch(matcher -> matcher.matches(remoteIp));
        if (passed) {
            // empty if block
        }
        return chain.filter(exchange);
    }
}

