/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter.reactive;

import java.net.URI;
import org.springframework.core.Ordered;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

public class TpServerLogoutFilter
implements WebFilter,
Ordered {
    private static final int order = -128;
    protected PathMatcher pathMatcher = new AntPathMatcher();
    protected String logoutPath = "/logout";

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.isLogoutRequest(exchange)) {
            return exchange.getSession().doOnNext(webSession -> webSession.invalidate()).flatMap(webSession -> {
                ServerHttpResponse response = exchange.getResponse();
                response.setStatusCode((HttpStatusCode)HttpStatus.SEE_OTHER);
                response.getHeaders().setLocation(URI.create("/"));
                return response.setComplete();
            });
        }
        return chain.filter(exchange);
    }

    private boolean isLogoutRequest(ServerWebExchange exchange) {
        String path = exchange.getRequest().getURI().getPath();
        return this.pathMatcher.match(this.logoutPath, path);
    }

    public int getOrder() {
        return -128;
    }
}

