/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.filter.reactive;

import com.cntaiping.fsc.core.util.NetUtils;
import com.cntaiping.fsc.core.util.SequenceUtil;
import com.cntaiping.fsc.security.util.SignatureUtil;
import java.util.TreeMap;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class TpTokenGatewayPreFilter
implements GlobalFilter,
Ordered {
    private final String appId;
    private final String clientIp;

    public TpTokenGatewayPreFilter(String appId) {
        this.appId = appId;
        this.clientIp = NetUtils.getLocalAddress();
    }

    private String generateAppToken(String appId, String clientIp, String random) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("x-app-client-ip", clientIp);
        params.put("x-app-id", appId);
        params.put("x-app-random", random);
        return SignatureUtil.createAppToken(params);
    }

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        HttpHeaders headers = request.getHeaders();
        ServerHttpRequest.Builder reqBuilder = request.mutate();
        if (!headers.containsKey((Object)"x-app-token")) {
            String random = SequenceUtil.createRandomNoMillisecond();
            String appToken = this.generateAppToken(this.appId, this.clientIp, random);
            reqBuilder.header("x-app-id", new String[]{this.appId});
            reqBuilder.header("x-app-random", new String[]{random});
            reqBuilder.header("x-app-token", new String[]{appToken});
            reqBuilder.header("x-app-client-ip", new String[]{this.clientIp});
        }
        ServerHttpRequest newReq = reqBuilder.build();
        return chain.filter(exchange.mutate().request(newReq).build());
    }

    public int getOrder() {
        return 0;
    }
}

