/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.interceptor;

import com.cntaiping.fsc.core.util.NetUtils;
import com.cntaiping.fsc.core.util.SequenceUtil;
import com.cntaiping.fsc.security.util.SignatureUtil;
import java.util.TreeMap;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

public class TpAppTokenExchangeFilterFunction
implements ExchangeFilterFunction {
    private final String appId;
    private final String clientIp;

    public TpAppTokenExchangeFilterFunction(String appId) {
        this.appId = appId;
        this.clientIp = NetUtils.getLocalAddress();
    }

    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        HttpHeaders headers = request.headers();
        if (!headers.containsKey((Object)"x-app-token")) {
            String random = SequenceUtil.createRandomNoMillisecond();
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("x-app-client-ip", this.clientIp);
            params.put("x-app-id", this.appId);
            params.put("x-app-random", random);
            String appToken = SignatureUtil.createAppToken(params);
            ClientRequest nextRequest = ClientRequest.from((ClientRequest)request).header("x-app-id", new String[]{this.appId}).header("x-app-random", new String[]{random}).header("x-app-token", new String[]{appToken}).header("x-app-client-ip", new String[]{this.clientIp}).build();
            return next.exchange(nextRequest);
        }
        return next.exchange(request);
    }
}

