/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.interceptor;

import com.cntaiping.fsc.core.util.NetUtils;
import com.cntaiping.fsc.core.util.SequenceUtil;
import com.cntaiping.fsc.security.util.SignatureUtil;
import java.io.IOException;
import java.util.TreeMap;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

public class TpAppTokenInterceptor
implements ClientHttpRequestInterceptor {
    private final String appId;
    private final String clientIp;

    public TpAppTokenInterceptor(String appId) {
        this.appId = appId;
        this.clientIp = NetUtils.getLocalAddress();
    }

    public ClientHttpResponse intercept(HttpRequest request, byte[] body, ClientHttpRequestExecution execution) throws IOException {
        HttpHeaders headers = request.getHeaders();
        String appToken = null;
        if (!headers.containsKey((Object)"x-app-token")) {
            String random = SequenceUtil.createRandomNoMillisecond();
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("x-app-client-ip", this.clientIp);
            params.put("x-app-id", this.appId);
            params.put("x-app-random", random);
            appToken = SignatureUtil.createAppToken(params);
            headers.set("x-app-id", this.appId);
            headers.set("x-app-random", random);
            headers.set("x-app-token", appToken);
            headers.set("x-app-client-ip", this.clientIp);
        }
        return execution.execute(request, body);
    }
}

