/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class TpKryoRedisSerializer
implements RedisSerializer<Object> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final ThreadLocal<Kryo> kryoHolder = ThreadLocal.withInitial(Kryo::new);
    private Kryo kryo = this.kryoHolder.get();

    public TpKryoRedisSerializer() {
        this.kryo.setReferences(false);
        this.kryo.register(Object.class);
    }

    public byte[] serialize(Object t) throws SerializationException {
        if (t == null) {
            return EMPTY_BYTE_ARRAY;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            Output output = new Output((OutputStream)baos);
            this.kryo.writeClassAndObject(output, t);
            output.flush();
            return baos.toByteArray();
        }
        catch (Exception ex) {
            throw new SerializationException("Could not serialize: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        try {
            return this.kryo.readClassAndObject(new Input(bytes));
        }
        catch (Exception ex) {
            throw new SerializationException("Could not deserialize: " + ex.getMessage(), (Throwable)ex);
        }
    }
}

