/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.internal;

import com.cntaiping.fsc.security.internal.TpTextEncryptor;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.env.OriginTrackedMapPropertySource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class TpPropertyDecrptor {
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrapProperties";
    public static final String PREFIX = "ENC@";
    public static final String BEGIN = "${";
    public static final String END = "}";
    public static final String REPLACE_STR = "ENC@.+\\}";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private TextEncryptor encryptor;
    private boolean failOnError = true;

    public TpPropertyDecrptor() {
        this.encryptor = new TpTextEncryptor();
    }

    public TpPropertyDecrptor(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    protected void decrypt(ConfigurableEnvironment env, PropertySource<?> source) {
        if (source instanceof OriginTrackedMapPropertySource && source.getName().contains("bootstrap.yml")) {
            this.decryptBootstrapPropertySource(env, (OriginTrackedMapPropertySource)source);
        } else if (source.getName().startsWith(BOOTSTRAP_PROPERTY_SOURCE_NAME)) {
            this.decryptCloudPropertySource(env, source);
        }
    }

    private void decryptCloudPropertySource(ConfigurableEnvironment env, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource subSource : ((CompositePropertySource)source).getPropertySources()) {
                this.decryptCloudPropertySource(env, subSource);
            }
        } else if (!source.getName().equals("configClient") && source.getSource() instanceof Map) {
            this.decrypt((Map)source.getSource());
        }
    }

    private void decryptBootstrapPropertySource(ConfigurableEnvironment env, OriginTrackedMapPropertySource source) {
        LinkedHashMap newSource = new LinkedHashMap((Map)source.getSource());
        OriginTrackedMapPropertySource newPropertySource = new OriginTrackedMapPropertySource(source.getName(), newSource);
        this.decrypt((Map)newPropertySource.getSource());
        env.getPropertySources().replace(source.getName(), (PropertySource)newPropertySource);
    }

    private void decrypt(Map<String, Object> properties) {
        properties.replaceAll((key, value) -> {
            String valueStr = value.toString();
            if (valueStr.startsWith(PREFIX)) {
                return this.decrypt((String)key, valueStr.substring(PREFIX.length()));
            }
            if (valueStr.contains(PREFIX) && valueStr.startsWith(BEGIN) && valueStr.endsWith(END)) {
                String subString = valueStr.substring(valueStr.indexOf(PREFIX) + PREFIX.length(), valueStr.length() - 1);
                return valueStr.replaceFirst(REPLACE_STR, this.decrypt((String)key, subString) + END);
            }
            return value;
        });
    }

    private String decrypt(String key, String encryptedString) {
        try {
            encryptedString = this.encryptor.decrypt(encryptedString);
        }
        catch (Exception e) {
            String message = "Cannot decrypt: key=" + key;
            if (this.logger.isDebugEnabled()) {
                this.logger.warn((Object)message, (Throwable)e);
            } else {
                this.logger.warn((Object)message);
            }
            if (this.failOnError) {
                throw new IllegalStateException(message, e);
            }
            return "";
        }
        return encryptedString;
    }
}

