/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.internal;

import com.cntaiping.fsc.core.util.LoggingSystemUtil;
import com.cntaiping.fsc.core.util.NetUtils;
import com.cntaiping.fsc.security.internal.TpPropertyDecrptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.logging.LoggingSystemProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.StringUtils;

public class TpPropertyDecrptorWrapper
implements ApplicationContextInitializer<ConfigurableApplicationContext>,
Ordered {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected static final String separator = "-";
    protected static Set<String> decryptedSet = new HashSet<String>();
    private TpPropertyDecrptor decrptor;
    protected int order;
    protected boolean isChanged = false;

    public TpPropertyDecrptorWrapper(TpPropertyDecrptor decrptor) {
        this.decrptor = decrptor;
    }

    public int getOrder() {
        return this.order;
    }

    public void initialize(ConfigurableApplicationContext applicationContext) {
        this.decrypt(applicationContext.getEnvironment());
    }

    protected void decrypt(ConfigurableEnvironment environment) {
        MutablePropertySources propertySources = environment.getPropertySources();
        for (PropertySource source : propertySources) {
            if (decryptedSet.contains(source.getName())) continue;
            this.decrptor.decrypt(environment, source);
            decryptedSet.add(source.getName());
        }
        this.initSystemProperty(environment);
    }

    private void initSystemProperty(ConfigurableEnvironment environment) {
        this.isChanged = false;
        this.logger.debug((Object)"Do TpPropertyDecrptorWrapper initSystemProperty..");
        String appName = environment.getProperty("spring.application.name");
        String ip = NetUtils.getLocalAddress();
        String port = environment.getProperty("server.port");
        this.setSystemProperty("SYS_NAME", environment.getProperty("app.sysName"), "TPCLOUD");
        this.setSystemProperty("APP_NAME", appName);
        this.setSystemProperty("APP_PORT", port);
        this.setSystemProperty("APP_IP", ip);
        if (StringUtils.hasText((String)port) && StringUtils.hasText((String)ip)) {
            this.setSystemProperty("INSTANCE", ip + ":" + port);
        }
        String envTag = environment.getProperty("spring.cloud.config.profile");
        String logFileName = null;
        if (StringUtils.hasText((String)appName) && StringUtils.hasText((String)port)) {
            logFileName = appName + separator + port;
        }
        this.setSystemProperty("APP_ENV", envTag, "ALL");
        this.setSystemProperty("APPLOG_TOPIC", environment.getProperty("app.log.appLogTopic"), "APPLOG_TOPIC");
        this.setSystemProperty("ENABLE_ROCKETMQ", environment.getProperty("app.log.enableRocketMqAppender"), "false");
        this.setSystemProperty("DEVMODE", environment.getProperty("app.log.isDevelopMode"), "true");
        try {
            this.setSystemProperty("HOST_NAME", InetAddress.getLocalHost().getHostName());
        }
        catch (UnknownHostException e) {
            this.logger.error((Object)("TpPropertyDecrptorWrapper setHostName fail! " + e.getLocalizedMessage()), (Throwable)e);
        }
        this.setSystemProperty(LoggingSystemProperties.LOG_PATH, environment.getProperty("logging.file.path"), "logs");
        this.setSystemProperty(LoggingSystemProperties.LOG_FILE, environment.getProperty("logging.file.name"), logFileName);
        if (this.isChanged) {
            LoggingSystemUtil.reinitializeLoggingSystem((ConfigurableEnvironment)environment);
        }
        if ("false".equalsIgnoreCase(System.getProperty("DEVMODE"))) {
            System.out.println("\u975e\u5f00\u53d1\u6a21\u5f0f\uff0c\u65e5\u5fd7\u4e0d\u4f1a\u8f93\u51fa\u5230\u63a7\u5236\u53f0\uff08console\uff09\uff0c\u8bf7\u5230\u6eda\u52a8\u5f0f\u65e5\u5fd7\u6587\u4ef6\uff08" + System.getProperty(LoggingSystemProperties.LOG_FILE) + ".out\uff09\u6216\u65e5\u5fd7\u5e73\u53f0\u67e5\u770b\u3002");
        }
    }

    private void setSystemProperty(String key, String value) {
        this.setSystemProperty(key, value, null);
    }

    private void setSystemProperty(String key, String value, String defaultValue) {
        if (StringUtils.hasText((String)value)) {
            String oldValue = System.getProperty(key);
            if (!value.equalsIgnoreCase(oldValue)) {
                System.setProperty(key, value);
                this.isChanged = true;
            }
        } else if (System.getProperty(key) == null && StringUtils.hasText((String)defaultValue)) {
            System.setProperty(key, defaultValue);
        }
    }
}

