/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.util;

import com.cntaiping.fsc.core.exception.TpcloudException;
import com.cntaiping.fsc.security.internal.TpTextEncryptor;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.crypto.encrypt.TextEncryptor;

public class AesUtil {
    public static final String ENC_PREFIX = "ENC@";
    public static final String DEFAULT_AESKEY = "Tpcloud!2019#0607";
    private static final String UTF8 = "utf-8";
    private static final int LENGTH = 256;
    private static final String ALGORITHM = "AES";
    private static final String RNG_ALGORITHM = "SHA1PRNG";
    private static TextEncryptor defaultTextEncryptor = new TpTextEncryptor();

    public static String getAesKey() {
        String aesKey = System.getenv("TPCLOUD_AESKEY");
        return StringUtils.isBlank((CharSequence)aesKey) ? DEFAULT_AESKEY : aesKey;
    }

    public static String encrypt(String text) {
        return defaultTextEncryptor.encrypt(text);
    }

    public static String decrypt(String encryptedText) {
        return defaultTextEncryptor.decrypt(encryptedText);
    }

    @Deprecated
    public static String aesEncrypt(String aesKey, String content) {
        byte[] encryptResult = AesUtil.encrypt(aesKey, content);
        return Base64.encodeBase64String((byte[])encryptResult);
    }

    @Deprecated
    public static String aesDecrypt(String aesKey, String encryptStr) {
        byte[] decrpt = Base64.decodeBase64((String)encryptStr);
        byte[] decryptResult = AesUtil.decrypt(aesKey, decrpt);
        return new String(decryptResult);
    }

    @Deprecated
    private static byte[] encrypt(String aesKey, String content) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance(RNG_ALGORITHM);
            secureRandom.setSeed(aesKey.getBytes(UTF8));
            kgen.init(256, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            byte[] byteContent = content.getBytes(UTF8);
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (Exception e) {
            throw new TpcloudException((Throwable)e);
        }
    }

    @Deprecated
    private static byte[] decrypt(String aesKey, byte[] content) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance(ALGORITHM);
            SecureRandom secureRandom = SecureRandom.getInstance(RNG_ALGORITHM);
            secureRandom.setSeed(aesKey.getBytes(UTF8));
            kgen.init(256, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, ALGORITHM);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key);
            byte[] result = cipher.doFinal(content);
            return result;
        }
        catch (Exception e) {
            throw new TpcloudException((Throwable)e);
        }
    }
}

