/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.security.util;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.cntaiping.fsc.core.util.SessionUtil;
import com.cntaiping.fsc.core.util.WebSessionUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ServerWebExchange;

public class SignatureUtil {
    protected static final Logger LOG = LoggerFactory.getLogger(SignatureUtil.class);
    private static final String DEFAULT_APP_SECRET;
    private static final String SIGNATURE_CONNECTOR = "&";
    private static final String KEY_VALUE_CONNECTOR = "=";

    public static String getAppToken(HttpServletRequest request) {
        return request.getHeader("x-app-token");
    }

    public static String generatePreSignature(TreeMap<String, String> params) {
        StringBuffer sBuffer = new StringBuffer();
        String lastKey = params.lastKey();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            sBuffer.append(entry.getKey());
            sBuffer.append(KEY_VALUE_CONNECTOR);
            sBuffer.append(entry.getValue());
            if (entry.getKey().equals(lastKey)) continue;
            sBuffer.append(SIGNATURE_CONNECTOR);
        }
        return sBuffer.toString();
    }

    public static String generateSignatureSha256Hex(String preSignature) {
        return DigestUtils.sha256Hex((String)preSignature);
    }

    public static String generateSignatureSha1Hex(String preSignature) {
        return DigestUtils.sha1Hex((String)preSignature);
    }

    public static String generateSignatureSha1HexBase64(String preSignature) {
        return Base64.getEncoder().encodeToString(DigestUtils.sha1Hex((String)preSignature).getBytes());
    }

    public static String createSignature(TreeMap<String, String> params) {
        return SignatureUtil.generateSignatureSha1Hex(SignatureUtil.generatePreSignature(params));
    }

    public static String createAppToken(TreeMap<String, String> params) {
        params.put("x-app-secret", DEFAULT_APP_SECRET);
        return SignatureUtil.createSignature(params);
    }

    public static String createAppToken(HttpSession session, String appId, String clientIp, String random) {
        String appToken = null;
        if (session != null) {
            appToken = (String)session.getAttribute("x-app-token");
        }
        if (!StringUtils.hasText(appToken)) {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("x-app-client-ip", clientIp);
            params.put("x-app-id", appId);
            params.put("x-app-random", random);
            params.put("x-app-secret", DEFAULT_APP_SECRET);
            appToken = SignatureUtil.createAppToken(params);
            if (session != null) {
                session.setAttribute("x-app-token", (Object)appToken);
            }
        }
        return appToken;
    }

    public static boolean validateAppToken(String requestToken, TreeMap<String, String> params) {
        String validateToken = null;
        if (params != null && params.size() > 2 && StringUtils.hasText((String)requestToken) && requestToken.equals(validateToken = SignatureUtil.createAppToken(params))) {
            return true;
        }
        LOG.warn("App Token validate fail! RequestToken: {}, ValidateToken: {}", (Object)requestToken, validateToken);
        return false;
    }

    public static String createSessionToken(String tpSessionId, String clientIp, String clientType) {
        return SignatureUtil.generateSignatureSha256Hex(tpSessionId + clientIp + clientType + DEFAULT_APP_SECRET);
    }

    public static boolean validateSessionToken(String tpSessionId, String requestToken, ServerWebExchange exchange) {
        if (StringUtils.hasText((String)requestToken)) {
            ServerHttpRequest request = exchange.getRequest();
            String clientType = WebSessionUtil.getClientType((ServerHttpRequest)request);
            String remoteHost = WebSessionUtil.getRemoteHost((ServerHttpRequest)request);
            String validateToken = SignatureUtil.createSessionToken(tpSessionId, remoteHost, clientType);
            if (requestToken.equals(validateToken)) {
                return true;
            }
        }
        LOG.warn("Session Token validate fail! RequestToken: {} ", (Object)requestToken);
        return false;
    }

    public static boolean validateSessionToken(String tpSessionId, String requestToken, HttpServletRequest request) {
        String validateToken;
        if (StringUtils.hasText((String)requestToken) && requestToken.equals(validateToken = SignatureUtil.createSessionToken(tpSessionId, SessionUtil.getRemoteHost((HttpServletRequest)request), SessionUtil.getClientType((HttpServletRequest)request)))) {
            return true;
        }
        LOG.warn("Session Token validate fail! RequestToken: {} ", (Object)requestToken);
        return false;
    }

    public static String createFsToken(String random, String clientIp, String clientType) {
        return SignatureUtil.generateSignatureSha1Hex(random + clientIp + clientType + DEFAULT_APP_SECRET);
    }

    public static String createFsToken(String random, HttpServletRequest request) {
        return SignatureUtil.createFsToken(random, SessionUtil.getRemoteHost((HttpServletRequest)request), SessionUtil.getClientType((HttpServletRequest)request));
    }

    public static boolean validateFsToken(String random, String requestToken, HttpServletRequest request) {
        String validateToken = null;
        if (StringUtils.hasText((String)requestToken) && requestToken.equals(validateToken = SignatureUtil.createFsToken(random, request))) {
            return true;
        }
        LOG.warn("FS Token validate fail! RequestToken: {}, ValidateToken: {}", (Object)requestToken, (Object)validateToken);
        return false;
    }

    public static String encryptStr(Map<String, String> params) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String result = SignatureUtil.getEncryptString(params);
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        byte[] res = mDigest.digest(result.getBytes());
        String hexStr = Hex.encodeHexString((byte[])res);
        byte[] encode = Base64.getEncoder().encode(hexStr.getBytes("UTF-8"));
        return new String(encode);
    }

    public static String getEncryptString(Map<String, String> params) {
        JSONObject jsonObject;
        if (StringUtils.hasText((String)params.get("body")) && (jsonObject = JSONObject.parseObject((String)params.get("body"), (Feature[])new Feature[]{Feature.OrderedField})).containsKey((Object)"file")) {
            jsonObject.remove((Object)"file");
            params.put("body", JSONObject.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        Set<String> keyset = params.keySet();
        ArrayList<String> list = new ArrayList<String>(keyset);
        Collections.sort(list);
        Object result = "";
        for (int i = 0; i < list.size(); ++i) {
            result = (String)result + (String)list.get(i) + KEY_VALUE_CONNECTOR + (params.get(list.get(i)) == null ? "" : params.get(list.get(i))) + SIGNATURE_CONNECTOR;
        }
        if (StringUtils.hasText((String)result) && ((String)result).endsWith(SIGNATURE_CONNECTOR)) {
            result = ((String)result).substring(0, ((String)result).length() - 1);
        }
        return result;
    }

    static {
        String sysTokenSalt = System.getenv("TPCLOUD_SECRET");
        DEFAULT_APP_SECRET = StringUtils.hasText((String)sysTokenSalt) ? sysTokenSalt : "TpCloud2021!!Bin##@5025";
    }
}

