/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.session.config;

import com.cntaiping.fsc.core.filter.ExceptionFilter;
import com.cntaiping.fsc.session.config.TpSessionProperties;
import com.cntaiping.fsc.session.util.TpCookieSerializer;
import com.cntaiping.fsc.session.util.TpHttpSessionIdResolver;
import com.cntaiping.fsc.session.util.reactive.TpWebSessionIdResolver;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.reactive.WebSessionIdResolverAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.ResponseCookie;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.HttpSessionIdResolver;
import org.springframework.web.server.session.CookieWebSessionIdResolver;
import org.springframework.web.server.session.HeaderWebSessionIdResolver;
import org.springframework.web.server.session.WebSessionIdResolver;

@Configuration
@EnableConfigurationProperties(value={TpSessionProperties.class})
@AutoConfiguration(before={WebSessionIdResolverAutoConfiguration.class})
@EnableScheduling
public class TpSessionConfig {
    protected static final Logger LOG = LoggerFactory.getLogger(TpSessionConfig.class);
    @Autowired
    protected TpSessionProperties tpSessionProperties;

    public TpSessionConfig() {
        LOG.info("Init TpSessionConfig.");
    }

    @Primary
    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public TpWebSessionIdResolver tpWebSessionIdResolver(List<WebSessionIdResolver> webSessionIdResolvers) {
        LOG.info("Init tpWebSessionIdResolver");
        return new TpWebSessionIdResolver(webSessionIdResolvers);
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public WebSessionIdResolver headerWebSessionIdResolver() {
        HeaderWebSessionIdResolver headerWebSessionIdResolver = new HeaderWebSessionIdResolver();
        headerWebSessionIdResolver.setHeaderName(this.getTpSessionKey());
        return headerWebSessionIdResolver;
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    public WebSessionIdResolver cookieWebSessionIdResolver() {
        CookieWebSessionIdResolver resolver = new CookieWebSessionIdResolver();
        resolver.setCookieName(this.getTpSessionKey());
        resolver.addCookieInitializer(this::initializeCookie);
        return resolver;
    }

    private String getTpSessionKey() {
        String name = this.tpSessionProperties.getCookie().getName();
        return name == null ? "TPSESSIONID" : name;
    }

    private void initializeCookie(ResponseCookie.ResponseCookieBuilder builder) {
        TpSessionProperties.Cookie cookie = this.tpSessionProperties.getCookie();
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        map.from(cookie::getDomain).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).domain(arg_0));
        map.from(cookie::getPath).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).path(arg_0));
        map.from(cookie::getHttpOnly).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).httpOnly(arg_0));
        map.from(cookie::getSecure).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).secure(arg_0));
        map.from(cookie::getMaxAge).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).maxAge(arg_0));
        map.from((Object)this.tpSessionProperties.getSameSite().getValue()).to(arg_0 -> ((ResponseCookie.ResponseCookieBuilder)builder).sameSite(arg_0));
    }

    @Bean
    @ConditionalOnMissingBean(value={ExceptionFilter.class})
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public ExceptionFilter exceptionFilter() {
        LOG.info("Init TpSessionConfig ExceptionFilter.");
        return new ExceptionFilter();
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public HttpSessionIdResolver httpSessionIdResolver() {
        LOG.info("Init TpSessionConfig TpHttpSessionIdResolver.");
        TpHttpSessionIdResolver httpSessionIdResolver = new TpHttpSessionIdResolver();
        TpSessionProperties.Cookie cookie = this.tpSessionProperties.getCookie();
        if (cookie.getName() == null) {
            cookie.setName("TPSESSIONID");
        }
        TpCookieSerializer cookieSerializer = new TpCookieSerializer(cookie.getName(), this.tpSessionProperties.getSessionTimeout());
        cookieSerializer.setSameSite(this.tpSessionProperties.getSameSite());
        cookieSerializer.setUseBase64Encoding(false);
        httpSessionIdResolver.setCookieSerializer((CookieSerializer)cookieSerializer);
        return httpSessionIdResolver;
    }
}

