/*
 * Decompiled with CFR 0.152.
 */
package com.cntaiping.fsc.session.util;

import com.cntaiping.fsc.core.util.SessionUtil;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

public class TpCookieSerializer
extends DefaultCookieSerializer {
    private String sessionCookieName = "TPSESSIONID";
    private int sessionCookieMaxAge = -1;
    private SessionUtil.SameSite sameSite = SessionUtil.SameSite.LAX;
    private boolean useBase64Encoding = false;

    public TpCookieSerializer() {
        super.setCookieName(this.sessionCookieName);
        super.setCookieMaxAge(this.sessionCookieMaxAge);
    }

    public TpCookieSerializer(String sessionCookieName, int sessionCookieMaxAge) {
        this.setCookieName(sessionCookieName);
        if (sessionCookieMaxAge > 0) {
            this.sessionCookieMaxAge = sessionCookieMaxAge;
            super.setCookieMaxAge(sessionCookieMaxAge);
        }
    }

    public void setCookieName(String cookieName) {
        if (cookieName != null) {
            this.sessionCookieName = cookieName;
        }
        super.setCookieName(this.sessionCookieName);
    }

    public List<String> readCookieValues(HttpServletRequest request) {
        List matchingCookieValues = SessionUtil.readCookie((HttpServletRequest)request, (String)this.sessionCookieName, (boolean)this.useBase64Encoding);
        return matchingCookieValues;
    }

    public void writeCookieValue(CookieSerializer.CookieValue cookieValue) {
        HttpServletRequest request = cookieValue.getRequest();
        HttpServletResponse response = cookieValue.getResponse();
        Cookie sessionCookie = new Cookie(this.sessionCookieName, cookieValue.getCookieValue());
        sessionCookie.setMaxAge(cookieValue.getCookieMaxAge());
        sessionCookie.setHttpOnly(true);
        SessionUtil.writeCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)sessionCookie, (boolean)this.useBase64Encoding, (SessionUtil.SameSite)this.sameSite);
    }

    public void setSameSite(SessionUtil.SameSite sameSite) {
        this.sameSite = sameSite;
    }

    public void setUseBase64Encoding(boolean useBase64Encoding) {
        this.useBase64Encoding = useBase64Encoding;
    }
}

